import request from '@/utils/request'

// 查询液化石油安检记录列表
export function listRecord(query) {
  return request({
    url: '/lpg/check/list',
    method: 'get',
    params: query
  })
}

// 查询液化石油安检记录详细
export function getRecord(safeCheckId) {
  return request({
    url: '/lpg/check/' + safeCheckId,
    method: 'get'
  })
}

// 新增液化石油安检记录
export function addRecord(data) {
  return request({
    url: '/lpg/check',
    method: 'post',
    data: data
  })
}

// 修改液化石油安检记录
export function updateRecord(data) {
  return request({
    url: '/lpg/check',
    method: 'put',
    data: data
  })
}

// 删除液化石油安检记录
export function delRecord(safeCheckId) {
  return request({
    url: '/lpg/check/' + safeCheckId,
    method: 'delete'
  })
}

// 导出液化石油安检记录
export function exportRecord(query) {
  return request({
    url: '/lpg/check/export',
    method: 'get',
    params: query
  })
}


// 下载用户导入模板
export function importTemplate() {
  return request({
    url: '/lpg/check/importTemplate',
    method: 'get'
  })
}