import request from '@/utils/request'

// 查询【请填写功能名称】列表
export function listCard(query) {
  return request({
    url: '/system/card/list',
    method: 'get',
    params: query
  })
}

export function patrolCardInfoList(query) {
  return request({
    url: '/system/card/patrolCardInfoList',
    method: 'get',
    params: query
  })
}

// 查询【请填写功能名称】详细
export function getCard(cardId) {
  return request({
    url: '/system/card/' + cardId,
    method: 'get'
  })
}

// 新增【请填写功能名称】
export function addCard(data) {
  return request({
    url: '/system/card',
    method: 'post',
    data: data
  })
}

// 修改【请填写功能名称】
export function updateCard(data) {
  return request({
    url: '/system/card',
    method: 'put',
    data: data
  })
}

// 删除【请填写功能名称】
export function delCard(cardId) {
  return request({
    url: '/system/card/' + cardId,
    method: 'delete'
  })
}

// 导出【请填写功能名称】
export function exportCard(query) {
  return request({
    url: '/system/card/export',
    method: 'get',
    params: query
  })
}
