import request from '@/utils/request'

// 查询安检记录列表
export function listRecord(query) {
  return request({
    url: '/safe/record/list',
    method: 'get',
    params: query
  })
}

// 查询安检记录详细
export function getRecord(safeCheckId) {
  return request({
    url: '/safe/record/' + safeCheckId,
    method: 'get'
  })
}

// 新增安检记录
export function addRecord(data) {
  return request({
    url: '/safe/record',
    method: 'post',
    data: data
  })
}

// 修改安检记录
export function updateRecord(data) {
  return request({
    url: '/safe/record',
    method: 'put',
    data: data
  })
}

// 删除安检记录
export function delRecord(safeCheckId) {
  return request({
    url: '/safe/record/' + safeCheckId,
    method: 'delete'
  })
}

// 导出安检记录
export function exportRecord(query) {
  return request({
    url: '/safe/record/export',
    method: 'get',
    params: query
  })
}
