import request from '@/utils/request'

// 查询应急演练列表
export function listRecord(query) {
  return request({
    url: '/emergencydrills/record/list',
    method: 'get',
    params: query
  })
}

// 查询应急演练详细
export function getRecord(fDrillsId) {
  return request({
    url: '/emergencydrills/record/getDetail/' + fDrillsId,
    method: 'get'
  })
}

// 新增应急演练
export function addRecord(data) {
  return request({
    url: '/emergencydrills/record',
    method: 'post',
    data: data
  })
}

// 修改应急演练
export function updateRecord(data) {
  return request({
    url: '/emergencydrills/record',
    method: 'put',
    data: data
  })
}

// 删除应急演练
export function delRecord(fDrillsId) {
  return request({
    url: '/emergencydrills/record/' + fDrillsId,
    method: 'delete'
  })
}

// 导出应急演练
export function exportRecord(query) {
  return request({
    url: '/emergencydrills/record/export',
    method: 'get',
    params: query
  })
}