import request from '@/utils/request'

// 查询探测器用户列表
export function listDetectorUser(query) {
  return request({
    url: '/supervise/user/list',
    method: 'get',
    params: query
  })
}

// 探测器用户列表 大屏端 massMarks标注方式
export function massMarksDetectorUserList(query) {
  return request({
    url: '/supervise/user/massMarksDetectorUserList',
    method: 'get',
    params: query
  })
}

// 探测器用户列表 大屏端 labelsLayerMarks 标注方式
export function labelsLayerMarksDetectorUserList(query) {
  return request({
    url: '/supervise/user/labelsLayerMarksDetectorUserList',
    method: 'get',
    params: query
  })
}

// 探测器用户列表 大屏端 labelsLayerMarks 标注方式 居民用户 特殊处理 带有 村 和 安全装置了。。。
export function labelsLayerMarksDUserVillageSafDevInfoMap(query) {
  return request({
    url: '/supervise/user/labelsLayerMarksDUserVillageSafDevInfoMap',
    method: 'get',
    params: query
  })
}



// 探测器用户列表
export function detectorUserList(query) {
  return request({
    url: '/supervise/user/detectorUserList',
    method: 'get',
    params: query
  })
}
export function yhqdetectorUserList(query) {
  return request({
    url: "/system/yehuaqiDevice/list",
    method: "get",
    params: {
      pageNum: 1,
      pageSize: 5,
      ...query,
    },
  });
}
// 探测器用户列表
export function getDetectorUserAlarmList(query) {
  return request({
    url: '/supervise/user/getDetectorUserAlarmList',
    method: 'get',
    params: query
  })
}

// 查询探测器用户详细
export function getDetectorUser(userId) {
  return request({
    url: '/supervise/user/' + userId,
    method: 'get'
  })
}

// 新增探测器用户
export function addDetectorUser(data) {
  return request({
    url: '/supervise/user',
    method: 'post',
    data: data
  })
}

// 修改探测器用户
export function updateDetectorUser(data) {
  return request({
    url: '/supervise/user',
    method: 'put',
    data: data
  })
}

// 删除探测器用户
export function delDetectorUser(userId) {
  return request({
    url: '/supervise/user/' + userId,
    method: 'delete'
  })
}

// 导出探测器用户
export function exportDetectorUser(query) {
  return request({
    url: '/detector/detectorUser/export',
    method: 'get',
    params: query
  })
}

export function getDetectorUserInspectInfo(query) {
  return request({
    url: '/supervise/user/getDetectorUserInspectInfo',
    method: 'get',
    params: query
  })
}

/**
 * 用户安检信息导出
 * @param query
 */
export function detectorUserExport(query) {
  return request({
    url: '/supervise/user/detectorUserExport',
    method: 'get',
    params: query
  })
}
