package com.zehong.system.service.impl;

import java.lang.reflect.Member;
import java.util.List;
import com.zehong.common.utils.DateUtils;
import com.zehong.system.domain.TLinePatrolPerson;
import com.zehong.system.domain.TWorkTaskPatrol;
import com.zehong.system.mapper.TLinePatrolPersonMapper;
import com.zehong.system.mapper.TWorkTaskPatrolMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TWorkTaskPatrolCardMapper;
import com.zehong.system.domain.TWorkTaskPatrolCard;
import com.zehong.system.service.ITWorkTaskPatrolCardService;

/**
 * 【请填写功能名称】Service业务层处理
 * 
 * @author zehong
 * @date 2023-09-15
 */
@Service
public class TWorkTaskPatrolCardServiceImpl implements ITWorkTaskPatrolCardService 
{
    @Autowired
    private TWorkTaskPatrolCardMapper tWorkTaskPatrolCardMapper;

    @Autowired
    private TWorkTaskPatrolMapper tWorkTaskPatrolMapper;
    @Autowired
    private TLinePatrolPersonMapper tLinePatrolPersonMapper;

    /**
     * 查询【请填写功能名称】
     * 
     * @param cardId 【请填写功能名称】ID
     * @return 【请填写功能名称】
     */
    @Override
    public TWorkTaskPatrolCard selectTWorkTaskPatrolCardById(Long cardId)
    {
        TWorkTaskPatrolCard c = tWorkTaskPatrolCardMapper.selectTWorkTaskPatrolCardById(cardId);
        TLinePatrolPerson p = tLinePatrolPersonMapper.selectTLinePatrolPersonById(c.getMemberId());
        if(p!=null){
            c.setMemberName(p.getPersonName());
        }
        return c;
    }

    /**
     * 查询【请填写功能名称】列表
     * 
     * @param tWorkTaskPatrolCard 【请填写功能名称】
     * @return 【请填写功能名称】
     */
    @Override
    public List<TWorkTaskPatrolCard> selectTWorkTaskPatrolCardList(TWorkTaskPatrolCard tWorkTaskPatrolCard)
    {
        return tWorkTaskPatrolCardMapper.selectTWorkTaskPatrolCardList(tWorkTaskPatrolCard);
    }

    /**
     * 新增【请填写功能名称】
     * 
     * @param tWorkTaskPatrolCard 【请填写功能名称】
     * @return 结果
     */
    @Override
    public int insertTWorkTaskPatrolCard(TWorkTaskPatrolCard tWorkTaskPatrolCard)
    {
        tWorkTaskPatrolCard.setCreateTime(DateUtils.getNowDate());
        return tWorkTaskPatrolCardMapper.insertTWorkTaskPatrolCard(tWorkTaskPatrolCard);
    }
    @Override
    public int addbytaskId(TWorkTaskPatrolCard tWorkTaskPatrolCard){
        TWorkTaskPatrol tp =new TWorkTaskPatrol();
        tp.setTaskId(tWorkTaskPatrolCard.getTaskId());
        tp.setMemberId(tWorkTaskPatrolCard.getMemberId());
        List<TWorkTaskPatrol> list = tWorkTaskPatrolMapper.selectTWorkTaskPatrolList(tp);
        TWorkTaskPatrol nowtp = list.get(0);
        tWorkTaskPatrolCard.setPatrolId(nowtp.getPatrolId());
        tWorkTaskPatrolCard.setCreateTime(DateUtils.getNowDate());
        return tWorkTaskPatrolCardMapper.insertTWorkTaskPatrolCard(tWorkTaskPatrolCard);
    }
    /**
     * 修改【请填写功能名称】
     * 
     * @param tWorkTaskPatrolCard 【请填写功能名称】
     * @return 结果
     */
    @Override
    public int updateTWorkTaskPatrolCard(TWorkTaskPatrolCard tWorkTaskPatrolCard)
    {
        return tWorkTaskPatrolCardMapper.updateTWorkTaskPatrolCard(tWorkTaskPatrolCard);
    }

    /**
     * 批量删除【请填写功能名称】
     * 
     * @param cardIds 需要删除的【请填写功能名称】ID
     * @return 结果
     */
    @Override
    public int deleteTWorkTaskPatrolCardByIds(Long[] cardIds)
    {
        return tWorkTaskPatrolCardMapper.deleteTWorkTaskPatrolCardByIds(cardIds);
    }

    /**
     * 删除【请填写功能名称】信息
     * 
     * @param cardId 【请填写功能名称】ID
     * @return 结果
     */
    @Override
    public int deleteTWorkTaskPatrolCardById(Long cardId)
    {
        return tWorkTaskPatrolCardMapper.deleteTWorkTaskPatrolCardById(cardId);
    }
}
