package com.zehong.system.service.impl;

import com.zehong.system.domain.TVehicleInfo;
import com.zehong.system.mapper.TVehicleInfoMapper;
import com.zehong.system.service.ITVehicleInfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 燃气车辆信息Service业务层处理
 *
 * @author zehong
 * @date 2022-03-17
 */
@Service
public class TVehicleInfoServiceImpl implements ITVehicleInfoService
{
    @Autowired
    private TVehicleInfoMapper tVehicleInfoMapper;

    /**
     * 查询燃气车辆信息
     *
     * @param vehicleId 燃气车辆信息ID
     * @return 燃气车辆信息
     */
    @Override
    public TVehicleInfo selectTVehicleInfoById(Long vehicleId)
    {
        return tVehicleInfoMapper.selectTVehicleInfoById(vehicleId);
    }

    /**
     * 查询燃气车辆信息列表
     *
     * @param tVehicleInfo 燃气车辆信息
     * @return 燃气车辆信息
     */
    @Override
    public List<TVehicleInfo> selectTVehicleInfoList(TVehicleInfo tVehicleInfo)
    {
        return tVehicleInfoMapper.selectTVehicleInfoList(tVehicleInfo);
    }

    /**
     * 新增燃气车辆信息
     *
     * @param tVehicleInfo 燃气车辆信息
     * @return 结果
     */
    @Override
    public int insertTVehicleInfo(TVehicleInfo tVehicleInfo)
    {
        return tVehicleInfoMapper.insertTVehicleInfo(tVehicleInfo);
    }

    /**
     * 修改燃气车辆信息
     *
     * @param tVehicleInfo 燃气车辆信息
     * @return 结果
     */
    @Override
    public int updateTVehicleInfo(TVehicleInfo tVehicleInfo)
    {
        return tVehicleInfoMapper.updateTVehicleInfo(tVehicleInfo);
    }

    /**
     * 批量删除燃气车辆信息
     *
     * @param vehicleIds 需要删除的燃气车辆信息ID
     * @return 结果
     */
    @Override
    public int deleteTVehicleInfoByIds(Long[] vehicleIds)
    {
        return tVehicleInfoMapper.deleteTVehicleInfoByIds(vehicleIds);
    }

    /**
     * 删除燃气车辆信息信息
     *
     * @param vehicleId 燃气车辆信息ID
     * @return 结果
     */
    @Override
    public int deleteTVehicleInfoById(Long vehicleId)
    {
        return tVehicleInfoMapper.deleteTVehicleInfoById(vehicleId);
    }

    /**
     * 微信小程序  车辆详细信息查询接口
     * @param tVehicleInfo
     * @return
     */
    @Override
    public TVehicleInfo getTVehicleInfo(TVehicleInfo tVehicleInfo) {
        return tVehicleInfoMapper.getTVehicleInfo(tVehicleInfo);
    }
}
