package com.zehong.system.service.impl;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.zehong.common.utils.SecurityUtils;
import com.zehong.system.domain.TSupBalGasSup;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TSupBalUsgDayMapper;
import com.zehong.system.domain.TSupBalUsgDay;
import com.zehong.system.service.ITSupBalUsgDayService;

/**
 * 供需平衡-企业每日填报Service业务层处理
 * 
 * @author zehong
 * @date 2024-06-25
 */
@Service
public class TSupBalUsgDayServiceImpl implements ITSupBalUsgDayService 
{
    @Autowired
    private TSupBalUsgDayMapper tSupBalUsgDayMapper;

    /**
     * 查询供需平衡-企业每日填报
     * 
     * @param fRepUsgDayId 供需平衡-企业每日填报ID
     * @return 供需平衡-企业每日填报
     */
    @Override
    public TSupBalUsgDay selectTSupBalUsgDayById(Long fRepUsgDayId)
    {
        return tSupBalUsgDayMapper.selectTSupBalUsgDayById(fRepUsgDayId);
    }

    /**
     * 查询供需平衡-企业每日填报列表
     * 
     * @param tSupBalUsgDay 供需平衡-企业每日填报
     * @return 供需平衡-企业每日填报
     */
    @Override
    public List<TSupBalUsgDay> selectTSupBalUsgDayList(TSupBalUsgDay tSupBalUsgDay)
    {
        return tSupBalUsgDayMapper.selectTSupBalUsgDayList(tSupBalUsgDay);
    }

    /**
     * 新增供需平衡-企业每日填报
     * 
     * @param tSupBalUsgDay 供需平衡-企业每日填报
     * @return 结果
     */
    @Override
    public int insertTSupBalUsgDay(TSupBalUsgDay tSupBalUsgDay)
    {
        tSupBalUsgDay.setfCreateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        tSupBalUsgDay.setfCompanyInfoId(SecurityUtils.getLoginUser().getUser().getDeptId());
        return tSupBalUsgDayMapper.insertTSupBalUsgDay(tSupBalUsgDay);
    }

    /**
     * 修改供需平衡-企业每日填报
     * 
     * @param tSupBalUsgDay 供需平衡-企业每日填报
     * @return 结果
     */
    @Override
    public int updateTSupBalUsgDay(TSupBalUsgDay tSupBalUsgDay)
    {
        tSupBalUsgDay.setfUpdateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        return tSupBalUsgDayMapper.updateTSupBalUsgDay(tSupBalUsgDay);
    }

    /**
     * 批量删除供需平衡-企业每日填报
     * 
     * @param fRepUsgDayIds 需要删除的供需平衡-企业每日填报ID
     * @return 结果
     */
    @Override
    public int deleteTSupBalUsgDayByIds(Long[] fRepUsgDayIds)
    {
        return tSupBalUsgDayMapper.deleteTSupBalUsgDayByIds(fRepUsgDayIds);
    }

    /**
     * 删除供需平衡-企业每日填报信息
     * 
     * @param fRepUsgDayId 供需平衡-企业每日填报ID
     * @return 结果
     */
    @Override
    public int deleteTSupBalUsgDayById(Long fRepUsgDayId)
    {
        return tSupBalUsgDayMapper.deleteTSupBalUsgDayById(fRepUsgDayId);
    }

    /**
     * 获取上报信息
     * @param companyId 企业id
     * @param calendarDate 上报时间
     * @return
     */
    @Override
    public TSupBalUsgDay getReportInfoByCompany(String companyId, String calendarDate) {
        Map<String,String> param = new HashMap();
        param.put("companyId",companyId);
        param.put("calendarDate",calendarDate);
        return tSupBalUsgDayMapper.getReportInfoByCompany(param);
    }

    /**
     * 上传日用气量记录
     * @param fRepUsgDayId 监管记录主键
     * @return
     */
    @Override
    public int reportSupBalGasDayRecInfo(Long fRepUsgDayId){
        TSupBalUsgDay tSupBalUsgDay = new TSupBalUsgDay();
        tSupBalUsgDay.setfRepUsgDayId(fRepUsgDayId);
        tSupBalUsgDay.setfGovUploadTime(new Date());
        tSupBalUsgDay.setfGovUploadStatus("1");
        return tSupBalUsgDayMapper.updateTSupBalUsgDay(tSupBalUsgDay);
    }

}
