package com.zehong.system.service.impl;

import java.util.Date;
import java.util.List;
import com.zehong.common.utils.DateUtils;
import com.zehong.common.utils.SecurityUtils;
import com.zehong.system.domain.TSupBalStopSupOprPressLog;
import com.zehong.system.mapper.TSupBalStopSupOprPressLogMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TSupBalStopSupMapper;
import com.zehong.system.domain.TSupBalStopSup;
import com.zehong.system.service.ITSupBalStopSupService;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;

/**
 * 供需平衡-停气监管Service业务层处理
 * 
 * @author zehong
 * @date 2024-06-21
 */
@Service
public class TSupBalStopSupServiceImpl implements ITSupBalStopSupService 
{
    @Autowired
    private TSupBalStopSupMapper tSupBalStopSupMapper;

    @Resource
    private TSupBalStopSupOprPressLogMapper tSupBalStopSupOprPressLogMapper;

    /**
     * 查询供需平衡-停气监管
     * 
     * @param fGasStopId 供需平衡-停气监管ID
     * @return 供需平衡-停气监管
     */
    @Override
    public TSupBalStopSup selectTSupBalStopSupById(Long fGasStopId)
    {
        return tSupBalStopSupMapper.selectTSupBalStopSupById(fGasStopId);
    }

    /**
     * 查询供需平衡-停气监管列表
     * 
     * @param tSupBalStopSup 供需平衡-停气监管
     * @return 供需平衡-停气监管
     */
    @Override
    public List<TSupBalStopSup> selectTSupBalStopSupList(TSupBalStopSup tSupBalStopSup)
    {
        return tSupBalStopSupMapper.selectTSupBalStopSupList(tSupBalStopSup);
    }

    /**
     * 新增供需平衡-停气监管
     * 
     * @param tSupBalStopSup 供需平衡-停气监管
     * @return 结果
     */
    @Override
    public int insertTSupBalStopSup(TSupBalStopSup tSupBalStopSup)
    {
        tSupBalStopSup.setCreateTime(DateUtils.getNowDate());
        tSupBalStopSup.setfCompanyInfoId(SecurityUtils.getLoginUser().getUser().getDeptId());
        return tSupBalStopSupMapper.insertTSupBalStopSup(tSupBalStopSup);
    }

    /**
     * 修改供需平衡-停气监管
     * 
     * @param tSupBalStopSup 供需平衡-停气监管
     * @return 结果
     */
    @Override
    public int updateTSupBalStopSup(TSupBalStopSup tSupBalStopSup)
    {
        tSupBalStopSup.setUpdateTime(DateUtils.getNowDate());
        if("2".equals(tSupBalStopSup.getfStopProgress())){
            tSupBalStopSup.setfRecoveryGasTime(new Date());
        }
        return tSupBalStopSupMapper.updateTSupBalStopSup(tSupBalStopSup);
    }

    /**
     * 批量删除供需平衡-停气监管
     * 
     * @param fGasStopIds 需要删除的供需平衡-停气监管ID
     * @return 结果
     */
    @Override
    public int deleteTSupBalStopSupByIds(Long[] fGasStopIds)
    {
        return tSupBalStopSupMapper.deleteTSupBalStopSupByIds(fGasStopIds);
    }

    /**
     * 删除供需平衡-停气监管信息
     * 
     * @param fGasStopId 供需平衡-停气监管ID
     * @return 结果
     */
    @Override
    public int deleteTSupBalStopSupById(Long fGasStopId)
    {
        return tSupBalStopSupMapper.deleteTSupBalStopSupById(fGasStopId);
    }

    /**
     * 上传停气监管记录
     * @param fGasStopId 停气监管记录主键
     * @return
     */
    @Override
    public int reportSupBalStopSupRecInfo(Long fGasStopId) {
        TSupBalStopSup tSupBalStopSup = new TSupBalStopSup();
        tSupBalStopSup.setfGasStopId(fGasStopId);
        tSupBalStopSup.setfGovUploadStatus("1");
        tSupBalStopSup.setfGovUploadTime(new Date());
        return tSupBalStopSupMapper.updateTSupBalStopSup(tSupBalStopSup);
    }

    /**
     * 改变停气状态
     * @param tSupBalStopSup
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public int changeStopStatus(TSupBalStopSup tSupBalStopSup){
        tSupBalStopSup.setUpdateTime(DateUtils.getNowDate());
        if("2".equals(tSupBalStopSup.getfStopProgress())){
            tSupBalStopSup.setfRecoveryGasTime(new Date());
        }
        TSupBalStopSupOprPressLog tSupBalStopSupOprPressLog = new TSupBalStopSupOprPressLog();
        tSupBalStopSupOprPressLog.setfGasStopId(tSupBalStopSup.getfGasStopId());
        tSupBalStopSupOprPressLog.setfStopProgress(tSupBalStopSup.getfStopProgress());
        tSupBalStopSupOprPressLog.setfOprDate(new Date());
        tSupBalStopSupOprPressLogMapper.insertTSupBalStopSupOprPressLog(tSupBalStopSupOprPressLog);
        return tSupBalStopSupMapper.updateTSupBalStopSup(tSupBalStopSup);
    }

}
