package com.zehong.system.service.impl;

import java.util.List;
import com.zehong.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TSpecialUserMapper;
import com.zehong.system.domain.TSpecialUser;
import com.zehong.system.service.ITSpecialUserService;

/**
 * 特殊用户管控Service业务层处理
 * 
 * @author zehong
 * @date 2026-02-02
 */
@Service
public class TSpecialUserServiceImpl implements ITSpecialUserService 
{
    @Autowired
    private TSpecialUserMapper tSpecialUserMapper;

    /**
     * 查询特殊用户管控
     * 
     * @param specialId 特殊用户管控ID
     * @return 特殊用户管控
     */
    @Override
    public TSpecialUser selectTSpecialUserById(Long specialId)
    {
        return tSpecialUserMapper.selectTSpecialUserById(specialId);
    }

    /**
     * 查询特殊用户管控列表
     * 
     * @param tSpecialUser 特殊用户管控
     * @return 特殊用户管控
     */
    @Override
    public List<TSpecialUser> selectTSpecialUserList(TSpecialUser tSpecialUser)
    {
        return tSpecialUserMapper.selectTSpecialUserList(tSpecialUser);
    }

    /**
     * 新增特殊用户管控
     * 
     * @param tSpecialUser 特殊用户管控
     * @return 结果
     */
    @Override
    public int insertTSpecialUser(TSpecialUser tSpecialUser)
    {
        tSpecialUser.setCreateTime(DateUtils.getNowDate());
        return tSpecialUserMapper.insertTSpecialUser(tSpecialUser);
    }

    /**
     * 修改特殊用户管控
     * 
     * @param tSpecialUser 特殊用户管控
     * @return 结果
     */
    @Override
    public int updateTSpecialUser(TSpecialUser tSpecialUser)
    {
        tSpecialUser.setUpdateTime(DateUtils.getNowDate());
        return tSpecialUserMapper.updateTSpecialUser(tSpecialUser);
    }

    /**
     * 批量删除特殊用户管控
     * 
     * @param specialIds 需要删除的特殊用户管控ID
     * @return 结果
     */
    @Override
    public int deleteTSpecialUserByIds(Long[] specialIds)
    {
        return tSpecialUserMapper.deleteTSpecialUserByIds(specialIds);
    }

    /**
     * 删除特殊用户管控信息
     * 
     * @param specialId 特殊用户管控ID
     * @return 结果
     */
    @Override
    public int deleteTSpecialUserById(Long specialId)
    {
        return tSpecialUserMapper.deleteTSpecialUserById(specialId);
    }
}
