package com.zehong.system.service.impl;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.zehong.common.core.domain.entity.SysDictData;
import com.zehong.common.core.domain.entity.SysRole;
import com.zehong.common.utils.DateUtils;
import com.zehong.common.utils.DictUtils;
import com.zehong.common.utils.SecurityUtils;
import com.zehong.system.domain.form.TSafeEquipmentStandingBookForm;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TSafeEquipmentStandingBookMapper;
import com.zehong.system.domain.TSafeEquipmentStandingBook;
import com.zehong.system.service.ITSafeEquipmentStandingBookService;

/**
 * 用户加装安全装置台账Service业务层处理
 * 
 * @author zehong
 * @date 2022-02-09
 */
@Service
public class TSafeEquipmentStandingBookServiceImpl implements ITSafeEquipmentStandingBookService 
{
    @Autowired
    private TSafeEquipmentStandingBookMapper tSafeEquipmentStandingBookMapper;

    /**
     * 查询用户加装安全装置台账
     * 
     * @param safeEquipmentId 用户加装安全装置台账ID
     * @return 用户加装安全装置台账
     */
    @Override
    public TSafeEquipmentStandingBook selectTSafeEquipmentStandingBookById(Long safeEquipmentId)
    {
        TSafeEquipmentStandingBook tSafeEquipmentStandingBook = tSafeEquipmentStandingBookMapper.selectTSafeEquipmentStandingBookById(safeEquipmentId);

        // 获取 安全装置类型 字段数据
        List<SysDictData> equipmentTypeDictDatas = DictUtils.getDictCache("t_equipment_type");
        Map<String, List<SysDictData>> collect = equipmentTypeDictDatas.stream().collect(Collectors.groupingBy(SysDictData::getDictValue));

        String equipmentType = tSafeEquipmentStandingBook.getEquipmentType();
        StringBuilder stringBuilder  = new StringBuilder();
        String[] split = equipmentType.split(",");
        for (int i = 0; i < split.length; i++) {
            String s = split[i];
            List<SysDictData> sysDictData = collect.get(s);
            if (sysDictData.size() > 0) {
                String dictLabel = sysDictData.get(0).getDictLabel();
                if (i == split.length - 1) {
                    stringBuilder.append(dictLabel);
                } else {
                    stringBuilder.append(dictLabel).append(",");
                }
            }
        }
        tSafeEquipmentStandingBook.setEquipmentTypeExplainDict(stringBuilder.toString());

        return tSafeEquipmentStandingBook;
    }

    /**
     * 查询用户加装安全装置台账列表
     * 
     * @param tSafeEquipmentStandingBook 用户加装安全装置台账
     * @return 用户加装安全装置台账
     */
    @Override
    public List<TSafeEquipmentStandingBook> selectTSafeEquipmentStandingBookList(TSafeEquipmentStandingBookForm tSafeEquipmentStandingBook)
    {
        // 20240725 调整 政府和企业都可以录，企业看自己，政府看所有
        if (isEnterprise() && tSafeEquipmentStandingBook != null) {
            tSafeEquipmentStandingBook.setEnterpriseId(SecurityUtils.getLoginUser().getUser().getDeptId());
        }

        // 获取 安全装置类型 字段数据
        List<SysDictData> equipmentTypeDictDatas = DictUtils.getDictCache("t_equipment_type");
        Map<String, List<SysDictData>> collect = equipmentTypeDictDatas.stream().collect(Collectors.groupingBy(SysDictData::getDictValue));
        List<TSafeEquipmentStandingBook> tSafeEquipmentStandingBooks = tSafeEquipmentStandingBookMapper.selectTSafeEquipmentStandingBookList(tSafeEquipmentStandingBook);
        if (tSafeEquipmentStandingBooks.size() > 0) {
            for (TSafeEquipmentStandingBook safeEquipmentStandingBook : tSafeEquipmentStandingBooks) {
                String equipmentType = safeEquipmentStandingBook.getEquipmentType();
                StringBuilder stringBuilder  = new StringBuilder();
                String[] split = equipmentType.split(",");
                for (int i = 0; i < split.length; i++) {
                    String s = split[i];
                    List<SysDictData> sysDictData = collect.get(s);
                    if (sysDictData.size() > 0) {
                        String dictLabel = sysDictData.get(0).getDictLabel();
                        if (i == split.length - 1) {
                            stringBuilder.append(dictLabel);
                        } else {
                            stringBuilder.append(dictLabel).append(",");
                        }
                    }
                }
                safeEquipmentStandingBook.setEquipmentTypeExplainDict(stringBuilder.toString());
            }
        }

        return tSafeEquipmentStandingBooks;
    }

    /**
     * 新增用户加装安全装置台账
     * 
     * @param tSafeEquipmentStandingBook 用户加装安全装置台账
     * @return 结果
     */
    @Override
    public int insertTSafeEquipmentStandingBook(TSafeEquipmentStandingBook tSafeEquipmentStandingBook)
    {
        tSafeEquipmentStandingBook.setCreateTime(DateUtils.getNowDate());
        return tSafeEquipmentStandingBookMapper.insertTSafeEquipmentStandingBook(tSafeEquipmentStandingBook);
    }

    /**
     * 修改用户加装安全装置台账
     * 
     * @param tSafeEquipmentStandingBook 用户加装安全装置台账
     * @return 结果
     */
    @Override
    public int updateTSafeEquipmentStandingBook(TSafeEquipmentStandingBook tSafeEquipmentStandingBook)
    {
        tSafeEquipmentStandingBook.setUpdateTime(DateUtils.getNowDate());
        return tSafeEquipmentStandingBookMapper.updateTSafeEquipmentStandingBook(tSafeEquipmentStandingBook);
    }

    /**
     * 批量删除用户加装安全装置台账
     * 
     * @param safeEquipmentIds 需要删除的用户加装安全装置台账ID
     * @return 结果
     */
    @Override
    public int deleteTSafeEquipmentStandingBookByIds(Long[] safeEquipmentIds)
    {
        return tSafeEquipmentStandingBookMapper.deleteTSafeEquipmentStandingBookByIds(safeEquipmentIds);
    }
    @Override
    public List<Map<String,Object>> selectCountByYears()
    {
        return tSafeEquipmentStandingBookMapper.selectCountByYears();
    }
    @Override
    public List<Map<String,Object>> selectCountByUserType(){
        return tSafeEquipmentStandingBookMapper.selectCountByUserType();
    }

    /**
     * 删除用户加装安全装置台账信息
     * 
     * @param safeEquipmentId 用户加装安全装置台账ID
     * @return 结果
     */
    @Override
    public int deleteTSafeEquipmentStandingBookById(Long safeEquipmentId)
    {
        return tSafeEquipmentStandingBookMapper.deleteTSafeEquipmentStandingBookById(safeEquipmentId);
    }

    /**
     * 判断是否为企业
     * @return
     */
    private boolean isEnterprise(){
        List<SysRole> roles = SecurityUtils.getLoginUser().getUser().getRoles();
        List<String> roleKeys = roles.stream().map(item -> item.getRoleKey()).collect(Collectors.toList());
        return roleKeys.contains("qy");
    }
}
