package com.zehong.system.service.impl;

import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.alibaba.fastjson.JSONObject;
import com.zehong.common.exception.CustomException;
import com.zehong.common.utils.GovernmentDataCopyUtil;
import com.zehong.common.utils.GovernmentDataUtil;
import com.zehong.system.domain.vo.ProAppInfoVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TProAppInforMapper;
import com.zehong.system.domain.TProAppInfor;
import com.zehong.system.service.ITProAppInforService;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;

/**
 * 行业专家库-专家申报Service业务层处理
 * 
 * @author zehong
 * @date 2024-05-06
 */
@Service
public class TProAppInforServiceImpl implements ITProAppInforService {

    private static final Logger log = LoggerFactory.getLogger(TProAppInforServiceImpl.class);

    @Autowired
    private TProAppInforMapper tProAppInforMapper;

    @Resource
    private GovernmentDataUtil governmentDataUtil;

    /**
     * 查询行业专家库-专家申报
     * 
     * @param fProAppInforId 行业专家库-专家申报ID
     * @return 行业专家库-专家申报
     */
    @Override
    public TProAppInfor selectTProAppInforById(Long fProAppInforId)
    {
        return tProAppInforMapper.selectTProAppInforById(fProAppInforId);
    }

    /**
     * 查询行业专家库-专家申报列表
     * 
     * @param tProAppInfor 行业专家库-专家申报
     * @return 行业专家库-专家申报
     */
    @Override
    public List<TProAppInfor> selectTProAppInforList(TProAppInfor tProAppInfor)
    {
        return tProAppInforMapper.selectTProAppInforList(tProAppInfor);
    }

    /**
     * 新增行业专家库-专家申报
     * 
     * @param tProAppInfor 行业专家库-专家申报
     * @return 结果
     */
    @Override
    public int insertTProAppInfor(TProAppInfor tProAppInfor)
    {
        tProAppInfor.setfUpdateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        return tProAppInforMapper.insertTProAppInfor(tProAppInfor);
    }

    /**
     * 修改行业专家库-专家申报
     * 
     * @param tProAppInfor 行业专家库-专家申报
     * @return 结果
     */
    @Override
    public int updateTProAppInfor(TProAppInfor tProAppInfor)
    {
        tProAppInfor.setfUpdateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        return tProAppInforMapper.updateTProAppInfor(tProAppInfor);
    }

    /**
     * 批量删除行业专家库-专家申报
     * 
     * @param fProAppInforIds 需要删除的行业专家库-专家申报ID
     * @return 结果
     */
    @Override
    public int deleteTProAppInforByIds(Long[] fProAppInforIds)
    {
        return tProAppInforMapper.deleteTProAppInforByIds(fProAppInforIds);
    }

    /**
     * 删除行业专家库-专家申报信息
     * 
     * @param fProAppInforId 行业专家库-专家申报ID
     * @return 结果
     */
    @Override
    public int deleteTProAppInforById(Long fProAppInforId)
    {
        return tProAppInforMapper.deleteTProAppInforById(fProAppInforId);
    }

    /**
     * 专家申报
     * @param fProAppInforId 专家数据
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public int reportProAppInfo(Long fProAppInforId) throws Exception {
        TProAppInfor updateInfo = new TProAppInfor();
        updateInfo.setfProAppInforId(fProAppInforId);
        updateInfo.setfRepStatus(Long.parseLong("1"));
        updateInfo.setfRepDate(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        int result = tProAppInforMapper.updateTProAppInfor(updateInfo);
        TProAppInfor appInfor = tProAppInforMapper.selectTProAppInforById(fProAppInforId);
        ProAppInfoVo proAppInfoVo = new ProAppInfoVo();
        GovernmentDataCopyUtil.copyToGovernData(appInfor,proAppInfoVo);
        List<ProAppInfoVo> data = new ArrayList<>();
        data.add(proAppInfoVo);
        JSONObject reportResult = governmentDataUtil.setInfo("professor/application/information","WRITE",data);
        log.info("专家申报结果===================" + reportResult.toJSONString());
        if(!"0".equals(reportResult.getString("resultCode"))) throw new CustomException("行业专家上报市局接口失败");
        return result;
    }
}
