package com.zehong.system.service.impl;

import java.util.List;
import com.zehong.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TPatrolWorkInfoMapper;
import com.zehong.system.domain.TPatrolWorkInfo;
import com.zehong.system.service.ITPatrolWorkInfoService;

/**
 * 巡检任务Service业务层处理
 * 
 * @author zehong
 * @date 2023-08-05
 */
@Service
public class TPatrolWorkInfoServiceImpl implements ITPatrolWorkInfoService 
{
    @Autowired
    private TPatrolWorkInfoMapper tPatrolWorkInfoMapper;

    /**
     * 查询巡检任务
     * 
     * @param workId 巡检任务ID
     * @return 巡检任务
     */
    @Override
    public TPatrolWorkInfo selectTPatrolWorkInfoById(Long workId)
    {
        return tPatrolWorkInfoMapper.selectTPatrolWorkInfoById(workId);
    }

    /**
     * 查询巡检任务列表
     * 
     * @param tPatrolWorkInfo 巡检任务
     * @return 巡检任务
     */
    @Override
    public List<TPatrolWorkInfo> selectTPatrolWorkInfoList(TPatrolWorkInfo tPatrolWorkInfo)
    {
        return tPatrolWorkInfoMapper.selectTPatrolWorkInfoList(tPatrolWorkInfo);
    }

    /**
     * 新增巡检任务
     * 
     * @param tPatrolWorkInfo 巡检任务
     * @return 结果
     */
    @Override
    public int insertTPatrolWorkInfo(TPatrolWorkInfo tPatrolWorkInfo)
    {
        tPatrolWorkInfo.setCreateTime(DateUtils.getNowDate());
        return tPatrolWorkInfoMapper.insertTPatrolWorkInfo(tPatrolWorkInfo);
    }

    /**
     * 修改巡检任务
     * 
     * @param tPatrolWorkInfo 巡检任务
     * @return 结果
     */
    @Override
    public int updateTPatrolWorkInfo(TPatrolWorkInfo tPatrolWorkInfo)
    {
        tPatrolWorkInfo.setUpdateTime(DateUtils.getNowDate());
        return tPatrolWorkInfoMapper.updateTPatrolWorkInfo(tPatrolWorkInfo);
    }

    /**
     * 批量删除巡检任务
     * 
     * @param workIds 需要删除的巡检任务ID
     * @return 结果
     */
    @Override
    public int deleteTPatrolWorkInfoByIds(Long[] workIds)
    {
        return tPatrolWorkInfoMapper.deleteTPatrolWorkInfoByIds(workIds);
    }

    /**
     * 删除巡检任务信息
     * 
     * @param workId 巡检任务ID
     * @return 结果
     */
    @Override
    public int deleteTPatrolWorkInfoById(Long workId)
    {
        return tPatrolWorkInfoMapper.deleteTPatrolWorkInfoById(workId);
    }
}
