package com.zehong.system.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import com.zehong.common.utils.DateUtils;
import com.zehong.common.utils.StringUtils;
import com.zehong.system.domain.TYehuaqiUser;
import com.zehong.system.domain.vo.TLpgSafeCheckRecordImportVo;
import com.zehong.system.mapper.TYehuaqiUserMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TLpgSafeCheckRecordMapper;
import com.zehong.system.domain.TLpgSafeCheckRecord;
import com.zehong.system.service.ITLpgSafeCheckRecordService;
import sun.swing.StringUIClientPropertyKey;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;

/**
 * 液化石油安检记录Service业务层处理
 * 
 * @author zehong
 * @date 2024-07-22
 */
@Service
public class TLpgSafeCheckRecordServiceImpl implements ITLpgSafeCheckRecordService 
{
    @Resource
    private TLpgSafeCheckRecordMapper tLpgSafeCheckRecordMapper;

    @Resource
    private TYehuaqiUserMapper yehuaqiUserMapper;

    /**
     * 查询液化石油安检记录
     * 
     * @param safeCheckId 液化石油安检记录ID
     * @return 液化石油安检记录
     */
    @Override
    public TLpgSafeCheckRecord selectTLpgSafeCheckRecordById(Long safeCheckId)
    {
        return tLpgSafeCheckRecordMapper.selectTLpgSafeCheckRecordById(safeCheckId);
    }

    /**
     * 查询液化石油安检记录列表
     * 
     * @param tLpgSafeCheckRecord 液化石油安检记录
     * @return 液化石油安检记录
     */
    @Override
    public List<TLpgSafeCheckRecord> selectTLpgSafeCheckRecordList(TLpgSafeCheckRecord tLpgSafeCheckRecord)
    {
        return tLpgSafeCheckRecordMapper.selectTLpgSafeCheckRecordList(tLpgSafeCheckRecord);
    }

    /**
     * 新增液化石油安检记录
     * 
     * @param tLpgSafeCheckRecord 液化石油安检记录
     * @return 结果
     */
    @Override
    public int insertTLpgSafeCheckRecord(TLpgSafeCheckRecord tLpgSafeCheckRecord)
    {
        tLpgSafeCheckRecord.setCreateTime(DateUtils.getNowDate());
        return tLpgSafeCheckRecordMapper.insertTLpgSafeCheckRecord(tLpgSafeCheckRecord);
    }

    /**
     * 批量插入
     * @param tLpgSafeCheckRecords t
     * @return r
     */
    @Override
    public int insertBatchContainPic(List<TLpgSafeCheckRecord> tLpgSafeCheckRecords) {
        return tLpgSafeCheckRecordMapper.insertBatchContainPic(tLpgSafeCheckRecords);
    }

    /**
     * 修改液化石油安检记录
     * 
     * @param tLpgSafeCheckRecord 液化石油安检记录
     * @return 结果
     */
    @Override
    public int updateTLpgSafeCheckRecord(TLpgSafeCheckRecord tLpgSafeCheckRecord)
    {
        tLpgSafeCheckRecord.setUpdateTime(DateUtils.getNowDate());
        return tLpgSafeCheckRecordMapper.updateTLpgSafeCheckRecord(tLpgSafeCheckRecord);
    }

    /**
     * 批量删除液化石油安检记录
     * 
     * @param safeCheckIds 需要删除的液化石油安检记录ID
     * @return 结果
     */
    @Override
    public int deleteTLpgSafeCheckRecordByIds(Long[] safeCheckIds)
    {
        return tLpgSafeCheckRecordMapper.deleteTLpgSafeCheckRecordByIds(safeCheckIds);
    }

    /**
     * 导入
     * @param XmbhList data
     * @param updateSupport 是否更新
     * @param response res
     * @return r
     */
    @Override
    public HashMap<String, Object> importLpgSafeCheckRecordInfo(List<TLpgSafeCheckRecordImportVo> XmbhList, boolean updateSupport, String deptId,HttpServletResponse response) {

        int errorNum = 0;
        int successNum = 0;

        List<TLpgSafeCheckRecord> lpgSafeCheckRecords = new ArrayList<>();

        TLpgSafeCheckRecord lpgSafeCheckRecord = null;

        for (TLpgSafeCheckRecordImportVo tLpgSafeCheckRecordImportVo : XmbhList) {
            lpgSafeCheckRecord = new TLpgSafeCheckRecord();
            if (StringUtils.isBlank(tLpgSafeCheckRecordImportVo.getGasUser())
            && StringUtils.isBlank(tLpgSafeCheckRecordImportVo.getTelNum())
            && StringUtils.isBlank(tLpgSafeCheckRecordImportVo.getGasUserAddress())
            && StringUtils.isBlank(tLpgSafeCheckRecordImportVo.getUserOwnId())) {
                errorNum++;
                continue;
            }

            if ((StringUtils.isBlank(tLpgSafeCheckRecordImportVo.getGasUser())
            || StringUtils.isBlank(tLpgSafeCheckRecordImportVo.getTelNum())
            || StringUtils.isBlank(tLpgSafeCheckRecordImportVo.getGasUserAddress()))
            && StringUtils.isBlank(tLpgSafeCheckRecordImportVo.getUserOwnId())) {
                errorNum++;
                continue;
            }

            if (StringUtils.isNotBlank(tLpgSafeCheckRecordImportVo.getUserOwnId())) {
                TYehuaqiUser yehuaqiUser = yehuaqiUserMapper.selectByUserOwnIdAndBeyondEnterpriseId(deptId,tLpgSafeCheckRecordImportVo.getUserOwnId());
                if (yehuaqiUser == null) {
                    List<TYehuaqiUser> yehuaqiUsers = yehuaqiUserMapper.selectByUsernameAndPhoneAndAddress(tLpgSafeCheckRecordImportVo.getGasUser(),
                            tLpgSafeCheckRecordImportVo.getTelNum(), tLpgSafeCheckRecordImportVo.getGasUserAddress());
                    if (yehuaqiUsers==null || yehuaqiUsers.size() == 0) {
                        errorNum ++;
                        continue;
                    }
                    lpgSafeCheckRecord.setUserId(yehuaqiUsers.get(0).getUserId());
                } else {
                    lpgSafeCheckRecord.setUserId(yehuaqiUser.getUserId());
                }
            } else {
                List<TYehuaqiUser> yehuaqiUsers = yehuaqiUserMapper.selectByUsernameAndPhoneAndAddress(tLpgSafeCheckRecordImportVo.getGasUser(),
                        tLpgSafeCheckRecordImportVo.getTelNum(), tLpgSafeCheckRecordImportVo.getGasUserAddress());
                if (yehuaqiUsers==null || yehuaqiUsers.size() == 0) {
                    errorNum ++;
                    continue;
                }
                lpgSafeCheckRecord.setUserId(yehuaqiUsers.get(0).getUserId());
            }

            lpgSafeCheckRecord.setStationName(tLpgSafeCheckRecordImportVo.getStationName());
            lpgSafeCheckRecord.setGasUserType(tLpgSafeCheckRecordImportVo.getGasUserType());
            lpgSafeCheckRecord.setTelNum(tLpgSafeCheckRecordImportVo.getTelNum());
            lpgSafeCheckRecord.setGasUserAddress(tLpgSafeCheckRecordImportVo.getGasUserAddress());
            lpgSafeCheckRecord.setSafeCheckDate(tLpgSafeCheckRecordImportVo.getSafeCheckDate());
            lpgSafeCheckRecord.setSafeCheckPerson(tLpgSafeCheckRecordImportVo.getSafeCheckPerson());
            lpgSafeCheckRecord.setBottleNum(tLpgSafeCheckRecordImportVo.getBottleNum());
            lpgSafeCheckRecord.setCheckInStatus(tLpgSafeCheckRecordImportVo.getCheckInStatus());
            // 六种状态
            lpgSafeCheckRecord.setStoveCheckStatus(tLpgSafeCheckRecordImportVo.getStoveCheckStatus());
            lpgSafeCheckRecord.setHoseCheckStatus(tLpgSafeCheckRecordImportVo.getHoseCheckStatus());
            lpgSafeCheckRecord.setValveCheckStatus(tLpgSafeCheckRecordImportVo.getValveCheckStatus());
            lpgSafeCheckRecord.setBottleCheckStatus(tLpgSafeCheckRecordImportVo.getBottleCheckStatus());
            lpgSafeCheckRecord.setAlarmCheckStatus(tLpgSafeCheckRecordImportVo.getAlarmCheckStatus());
            lpgSafeCheckRecord.setPlaceCheckStatus(tLpgSafeCheckRecordImportVo.getPlaceCheckStatus());

            lpgSafeCheckRecords.add(lpgSafeCheckRecord);
            successNum++;

        }

        if (lpgSafeCheckRecords.size() > 0) {
            tLpgSafeCheckRecordMapper.insertBatch(lpgSafeCheckRecords);
        }

        HashMap<String,Object> map = new HashMap<>();
        map.put("errorNum",errorNum);
        map.put("successNum",successNum);
        return map;
    }

    /**
     * 删除液化石油安检记录信息
     * 
     * @param safeCheckId 液化石油安检记录ID
     * @return 结果
     */
    @Override
    public int deleteTLpgSafeCheckRecordById(Long safeCheckId)
    {
        return tLpgSafeCheckRecordMapper.deleteTLpgSafeCheckRecordById(safeCheckId);
    }
}
