package com.zehong.system.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.utils.StringUtils;
import com.zehong.system.domain.TEnterpriseInfo;
import com.zehong.system.mapper.TEnterpriseInfoMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TLpgGasBottleFilesMapper;
import com.zehong.system.domain.TLpgGasBottleFiles;
import com.zehong.system.service.ITLpgGasBottleFilesService;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;

/**
 * 液化石油气-气瓶档案Service业务层处理
 * 
 * @author zehong
 * @date 2024-07-09
 */
@Service
public class TLpgGasBottleFilesServiceImpl implements ITLpgGasBottleFilesService 
{
    @Resource
    private TLpgGasBottleFilesMapper tLpgGasBottleFilesMapper;

    @Resource
    private TEnterpriseInfoMapper enterpriseInfoMapper;


    /**
     * 查询液化石油气-气瓶档案
     * 
     * @param fGasBottleFilesId 液化石油气-气瓶档案ID
     * @return 液化石油气-气瓶档案
     */
    @Override
    public TLpgGasBottleFiles selectTLpgGasBottleFilesById(Long fGasBottleFilesId)
    {
        return tLpgGasBottleFilesMapper.selectTLpgGasBottleFilesById(fGasBottleFilesId);
    }

    /**
     * 查询液化石油气-气瓶档案列表
     * 
     * @param tLpgGasBottleFiles 液化石油气-气瓶档案
     * @return 液化石油气-气瓶档案
     */
    @Override
    public List<TLpgGasBottleFiles> selectTLpgGasBottleFilesList(TLpgGasBottleFiles tLpgGasBottleFiles)
    {
        return tLpgGasBottleFilesMapper.selectTLpgGasBottleFilesList(tLpgGasBottleFiles);
    }

    /**
     * 导出
     * @param tLpgGasBottleFiles t
     * @return r
     */
    @Override
    public List<TLpgGasBottleFiles> exportTLpgGasBottleFilesList(TLpgGasBottleFiles tLpgGasBottleFiles) {
        return tLpgGasBottleFilesMapper.exportTLpgGasBottleFilesList(tLpgGasBottleFiles);
    }

    /**
     * 新增液化石油气-气瓶档案
     * 
     * @param tLpgGasBottleFiles 液化石油气-气瓶档案
     * @return 结果
     */
    @Override
    public int insertTLpgGasBottleFiles(TLpgGasBottleFiles tLpgGasBottleFiles)
    {
        return tLpgGasBottleFilesMapper.insertTLpgGasBottleFiles(tLpgGasBottleFiles);
    }

    /**
     * 修改液化石油气-气瓶档案
     * 
     * @param tLpgGasBottleFiles 液化石油气-气瓶档案
     * @return 结果
     */
    @Override
    public int updateTLpgGasBottleFiles(TLpgGasBottleFiles tLpgGasBottleFiles)
    {
        return tLpgGasBottleFilesMapper.updateTLpgGasBottleFiles(tLpgGasBottleFiles);
    }

    /**
     * 批量删除液化石油气-气瓶档案
     * 
     * @param fGasBottleFilesIds 需要删除的液化石油气-气瓶档案ID
     * @return 结果
     */
    @Override
    public int deleteTLpgGasBottleFilesByIds(Long[] fGasBottleFilesIds)
    {
        return tLpgGasBottleFilesMapper.deleteTLpgGasBottleFilesByIds(fGasBottleFilesIds);
    }

    /**
     * 删除液化石油气-气瓶档案信息
     * 
     * @param fGasBottleFilesId 液化石油气-气瓶档案ID
     * @return 结果
     */
    @Override
    public int deleteTLpgGasBottleFilesById(Long fGasBottleFilesId)
    {
        return tLpgGasBottleFilesMapper.deleteTLpgGasBottleFilesById(fGasBottleFilesId);
    }

    /**
     * 气瓶档案导入
     * @param xmbhList data
     * @param updateSupport 是否更新
     * @param response res
     * @return r
     */
    @Override
    public AjaxResult importLpgGasBottleFilesInfo(List<TLpgGasBottleFiles> xmbhList, boolean updateSupport, HttpServletResponse response) {

        int successNum = 0;
        int errorNum = 0;

        Map<String ,Object> map = new HashMap<>();
        if (xmbhList.size() > 0) {
            // 2024-09-14 加上企业信息了
            List<TLpgGasBottleFiles> successDataList = new ArrayList<>();

            // 过滤下有 企业名称的
            List<TLpgGasBottleFiles> collect = xmbhList.stream().filter(item -> StringUtils.isNotBlank(item.getEnterpriseName())).collect(Collectors.toList());

            errorNum += (xmbhList.size() - collect.size());

            // 企业名称集合 根据企业名称集合查询 企业是否存在
            List<String> collect1 = collect.stream().map(item -> item.getEnterpriseName()).collect(Collectors.toList());

            // 企业集合
            List<TEnterpriseInfo> tEnterpriseInfos = enterpriseInfoMapper.queryAllByEnterpriseNameList(collect1);

            // 根据企业名称分组
            Map<String, List<TEnterpriseInfo>> collect2 = tEnterpriseInfos.stream().collect(Collectors.groupingBy(TEnterpriseInfo::getEnterpriseName));

            for (TLpgGasBottleFiles tLpgGasBottleFiles : collect) {
                List<TEnterpriseInfo> tEnterpriseInfos1 = collect2.get(tLpgGasBottleFiles.getEnterpriseName());
                if (tEnterpriseInfos1 != null) {
                    successDataList.add(tLpgGasBottleFiles);
                    successNum++;
                } else {
                    errorNum ++;
                }
            }

            if (successDataList.size() > 0) {
                tLpgGasBottleFilesMapper.insertBatch(successDataList);
            }

        }
        map.put("errorNum",errorNum);
        map.put("successNum",successNum);

        return AjaxResult.success(map);
    }

    /**
     * 第三方对接 创建数据
     * @param list d
     * @return r
     */
    @Override
    public int externalDockingCreateLpgGasBottleFiles(List<TLpgGasBottleFiles> list) {

        return tLpgGasBottleFilesMapper.insertBatch(list);
    }

    /**
     * 第三方对接 修改数据
     * @param list list
     * @return r
     */
    @Override
    public int externalDockingUpdateLpgGasBottleFiles(List<TLpgGasBottleFiles> list) {
        return tLpgGasBottleFilesMapper.updateBatch(list);
    }

    /**
     * 根据气瓶条码集合 查询 气瓶集合
     * @param list l
     * @return r
     */
    @Override
    public List<TLpgGasBottleFiles> queryALlByQrcodeList(List<String> list) {
        return tLpgGasBottleFilesMapper.queryAllByFQRcodeList(list);
    }

    @Override
    public List<TLpgGasBottleFiles> queryAllByQrcodeAndEnterpriseList(List<String> list, String enterpriseId) {
        return tLpgGasBottleFilesMapper.queryAllByQrcodeAndEnterpriseList(list,enterpriseId);
    }
}
