package com.zehong.system.service.impl;

import java.util.List;
import com.zehong.common.utils.DateUtils;
import com.zehong.common.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TLinePatrolPersonMapper;
import com.zehong.system.domain.TLinePatrolPerson;
import com.zehong.system.service.ITLinePatrolPersonService;

/**
 * 巡线人员管理Service业务层处理
 * 
 * @author zehong
 * @date 2023-09-13
 */
@Service
public class TLinePatrolPersonServiceImpl implements ITLinePatrolPersonService 
{
    @Autowired
    private TLinePatrolPersonMapper tLinePatrolPersonMapper;

    /**
     * 查询巡线人员管理
     * 
     * @param personId 巡线人员管理ID
     * @return 巡线人员管理
     */
    @Override
    public TLinePatrolPerson selectTLinePatrolPersonById(Long personId)
    {
        return tLinePatrolPersonMapper.selectTLinePatrolPersonById(personId);
    }

    /**
     * 查询巡线人员管理列表
     * 
     * @param tLinePatrolPerson 巡线人员管理
     * @return 巡线人员管理
     */
    @Override
    public List<TLinePatrolPerson> selectTLinePatrolPersonList(TLinePatrolPerson tLinePatrolPerson)
    {
        return tLinePatrolPersonMapper.selectTLinePatrolPersonList(tLinePatrolPerson);
    }

    /**
     * 小程序接口
     * @param tLinePatrolPerson 巡线人员管理
     * @return
     */
    @Override
    public List<TLinePatrolPerson> appPersonList(TLinePatrolPerson tLinePatrolPerson)
    {
        return tLinePatrolPersonMapper.appPersonList(tLinePatrolPerson);
    }


    /**
     * 新增巡线人员管理
     * 
     * @param tLinePatrolPerson 巡线人员管理
     * @return 结果
     */
    @Override
    public int insertTLinePatrolPerson(TLinePatrolPerson tLinePatrolPerson)
    {
        tLinePatrolPerson.setCreateTime(DateUtils.getNowDate());
        tLinePatrolPerson.setBeyondEnterpriseId(SecurityUtils.getLoginUser().getUser().getDeptId());
        return tLinePatrolPersonMapper.insertTLinePatrolPerson(tLinePatrolPerson);
    }

    /**
     * 修改巡线人员管理
     * 
     * @param tLinePatrolPerson 巡线人员管理
     * @return 结果
     */
    @Override
    public int updateTLinePatrolPerson(TLinePatrolPerson tLinePatrolPerson)
    {
        tLinePatrolPerson.setUpdateTime(DateUtils.getNowDate());
        return tLinePatrolPersonMapper.updateTLinePatrolPerson(tLinePatrolPerson);
    }

    /**
     * 批量删除巡线人员管理
     * 
     * @param personIds 需要删除的巡线人员管理ID
     * @return 结果
     */
    @Override
    public int deleteTLinePatrolPersonByIds(Long[] personIds)
    {
        return tLinePatrolPersonMapper.deleteTLinePatrolPersonByIds(personIds);
    }

    /**
     * 删除巡线人员管理信息
     * 
     * @param personId 巡线人员管理ID
     * @return 结果
     */
    @Override
    public int deleteTLinePatrolPersonById(Long personId)
    {
        return tLinePatrolPersonMapper.deleteTLinePatrolPersonById(personId);
    }
}
