package com.zehong.system.service.impl;
import java.util.List;
import com.zehong.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TInspectionAccidentMapper;
import com.zehong.system.domain.TInspectionAccident;
import com.zehong.system.service.ITInspectionAccidentService;

/**
 * 巡检事故Service业务层处理
 *
 * @author zehong
 * @date 2026-02-02
 */
@Service
public class TInspectionAccidentServiceImpl implements ITInspectionAccidentService
{
    @Autowired
    private TInspectionAccidentMapper tInspectionAccidentMapper;

    /**
     * 查询巡检事故
     *
     * @param id 巡检事故ID
     * @return 巡检事故
     */
    @Override
    public TInspectionAccident selectTInspectionAccidentById(Long id)
    {
        return tInspectionAccidentMapper.selectTInspectionAccidentById(id);
    }

    /**
     * 查询巡检事故列表
     *
     * @param tInspectionAccident 巡检事故
     * @return 巡检事故
     */
    @Override
    public List<TInspectionAccident> selectTInspectionAccidentList(TInspectionAccident tInspectionAccident)
    {
        return tInspectionAccidentMapper.selectTInspectionAccidentList(tInspectionAccident);
    }

    /**
     * 新增巡检事故
     *
     * @param tInspectionAccident 巡检事故
     * @return 结果
     */
    @Override
    public int insertTInspectionAccident(TInspectionAccident tInspectionAccident)
    {
        tInspectionAccident.setCreateTime(DateUtils.getNowDate());
        return tInspectionAccidentMapper.insertTInspectionAccident(tInspectionAccident);
    }

    /**
     * 修改巡检事故
     *
     * @param tInspectionAccident 巡检事故
     * @return 结果
     */
    @Override
    public int updateTInspectionAccident(TInspectionAccident tInspectionAccident)
    {
        return tInspectionAccidentMapper.updateTInspectionAccident(tInspectionAccident);
    }

    /**
     * 批量删除巡检事故
     *
     * @param ids 需要删除的巡检事故ID
     * @return 结果
     */
    @Override
    public int deleteTInspectionAccidentByIds(Long[] ids)
    {
        return tInspectionAccidentMapper.deleteTInspectionAccidentByIds(ids);
    }

    /**
     * 删除巡检事故信息
     *
     * @param id 巡检事故ID
     * @return 结果
     */
    @Override
    public int deleteTInspectionAccidentById(Long id)
    {
        return tInspectionAccidentMapper.deleteTInspectionAccidentById(id);
    }

    @Override
    public int insertBatch(List<TInspectionAccident> tInspectionAccident) {
        return tInspectionAccidentMapper.insertBatch(tInspectionAccident);
    }
}