package com.zehong.system.service.impl;

import com.zehong.common.utils.DateUtils;
import com.zehong.system.domain.TAirChargeRecord;
import com.zehong.system.domain.TGasBottleTrackRecord;
import com.zehong.system.mapper.TAirChargeRecordMapper;
import com.zehong.system.mapper.TGasBottleTrackRecordMapper;
import com.zehong.system.service.ITGasBottleTrackRecordService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * 气瓶追溯Service业务层处理
 *
 * @author zehong
 * @date 2023-08-18
 */
@Service
public class TGasBottleTrackRecordServiceImpl implements ITGasBottleTrackRecordService
{
    @Autowired
    private TGasBottleTrackRecordMapper tGasBottleTrackRecordMapper;

    @Resource
    private TAirChargeRecordMapper tAirChargeRecordMapper;

    /**
     * 查询气瓶追溯
     *
     * @param trackRecordId 气瓶追溯ID
     * @return 气瓶追溯
     */
    @Override
    public TGasBottleTrackRecord selectTGasBottleTrackRecordById(Long trackRecordId)
    {
        return tGasBottleTrackRecordMapper.selectTGasBottleTrackRecordById(trackRecordId);
    }

    /**
     * 查询气瓶追溯列表
     *
     * @param tGasBottleTrackRecord 气瓶追溯
     * @return 气瓶追溯
     */
    @Override
    public List<TGasBottleTrackRecord> selectTGasBottleTrackRecordList(TGasBottleTrackRecord tGasBottleTrackRecord)
    {
        List<TGasBottleTrackRecord> records = tGasBottleTrackRecordMapper.selectTGasBottleTrackRecordList(tGasBottleTrackRecord);
        records.stream().forEach(item ->{
            StringBuilder massage = new StringBuilder("");
            if("0".equals(item.getProcessesName())){
                TAirChargeRecord charge = tAirChargeRecordMapper.selectTAirChargeRecordById(item.getProcessesRelationId());
                massage.append("由【"+ charge.getStationName() +"储配站 】")
                        .append("从业人员: " + charge.getChargeOperatorName() + "")
                        .append("给编号" + charge.getBottleCode() + "气瓶充气成功");
            }
            if("1".equals(item.getProcessesName())){
                massage.append("由【"+ item.getStationName() +"储配站 】")
                        .append("配送人员: "+ item.getName())
                        .append("配送气瓶到客户"+item.getGasUserName());
            }
            if("2".equals(item.getProcessesName())){
                massage.append("由【"+ item.getStationName() +"储配站 】")
                        .append("从业人员:" + item.getName())
                       .append("回收编号 "+ item.getBottleCode() +" 气瓶");
            }
            item.setMessageInfo(massage.toString());
        });
        return records;
    }




    /**
     * 新增气瓶追溯
     *
     * @param tGasBottleTrackRecord 气瓶追溯
     * @return 结果
     */
    @Override
    public int insertTGasBottleTrackRecord(TGasBottleTrackRecord tGasBottleTrackRecord)
    {
        tGasBottleTrackRecord.setCreateTime(DateUtils.getNowDate());
        return tGasBottleTrackRecordMapper.insertTGasBottleTrackRecord(tGasBottleTrackRecord);
    }

    /**
     * 修改气瓶追溯
     *
     * @param tGasBottleTrackRecord 气瓶追溯
     * @return 结果
     */
    @Override
    public int updateTGasBottleTrackRecord(TGasBottleTrackRecord tGasBottleTrackRecord)
    {
        tGasBottleTrackRecord.setUpdateTime(DateUtils.getNowDate());
        return tGasBottleTrackRecordMapper.updateTGasBottleTrackRecord(tGasBottleTrackRecord);
    }

    /**
     * 批量删除气瓶追溯
     *
     * @param trackRecordIds 需要删除的气瓶追溯ID
     * @return 结果
     */
    @Override
    public int deleteTGasBottleTrackRecordByIds(Long[] trackRecordIds)
    {
        return tGasBottleTrackRecordMapper.deleteTGasBottleTrackRecordByIds(trackRecordIds);
    }

    /**
     * 删除气瓶追溯信息
     *
     * @param trackRecordId 气瓶追溯ID
     * @return 结果
     */
    @Override
    public int deleteTGasBottleTrackRecordById(Long trackRecordId)
    {
        return tGasBottleTrackRecordMapper.deleteTGasBottleTrackRecordById(trackRecordId);
    }
}
