package com.zehong.system.service.impl;

import java.util.List;

import com.alibaba.fastjson.JSONObject;
import com.zehong.common.utils.DateUtils;
import com.zehong.system.controller.WebSocketController;
import com.zehong.system.domain.TEventHandle;
import com.zehong.system.mapper.TEventHandleMapper;
import com.zehong.system.service.WebSocketServer;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TEventReceiveMapper;
import com.zehong.system.domain.TEventReceive;
import com.zehong.system.service.ITEventReceiveService;

/**
 * 事件接报Service业务层处理
 * 
 * @author zehong
 * @date 2022-03-18
 */
@Slf4j
@Service
public class TEventReceiveServiceImpl implements ITEventReceiveService 
{
    @Autowired
    private TEventReceiveMapper tEventReceiveMapper;
    @Autowired
    private TEventHandleMapper tEventHandleMapper;
    @Autowired
    private WebSocketServer webSocketServer;

    /**
     * 查询事件接报
     * 
     * @param id 事件接报ID
     * @return 事件接报
     */
    @Override
    public TEventReceive selectTEventReceiveById(String id)
    {
        return tEventReceiveMapper.selectTEventReceiveById(id);
    }

    /**
     * 查询事件接报列表
     * 
     * @param tEventReceive 事件接报
     * @return 事件接报
     */
    @Override
    public List<TEventReceive> selectTEventReceiveList(TEventReceive tEventReceive)
    {
        List<TEventReceive> list = tEventReceiveMapper.selectTEventReceiveList(tEventReceive);
        for (TEventReceive t:list){
            TEventHandle h = tEventHandleMapper.selectByLast(t.getId());
            t.setHandleList(h);
        }
        return list;
    }

    /**
     * 新增事件接报
     * 
     * @param tEventReceive 事件接报
     * @return 结果
     */
    @Override
    public int insertTEventReceive(TEventReceive tEventReceive)
    {
        if(tEventReceive.getEnterpriseId()!=null){
            tEventReceive.setStatus(2);
        }
        tEventReceive.setCreateTime(DateUtils.getNowDate());
        return tEventReceiveMapper.insertTEventReceive(tEventReceive);
    }

    /**
     * 修改事件接报
     * 
     * @param tEventReceive 事件接报
     * @return 结果
     */
    @Override
    public int updateTEventReceive(TEventReceive tEventReceive)
    {
        int a = tEventReceiveMapper.updateTEventReceive(tEventReceive);
        try {
            //List<TEventReceive> list = tEventReceiveService.getReadReceiveList( enterpriseId);
            webSocketServer.batchSendMessage(JSONObject.toJSONString("success"));
        } catch (Exception e) {
            log.error("wesocket发送失败！");
        }
        return a;
    }

    /**
     * 批量删除事件接报
     * 
     * @param ids 需要删除的事件接报ID
     * @return 结果
     */
    @Override
    public int deleteTEventReceiveByIds(String[] ids)
    {
        return tEventReceiveMapper.deleteTEventReceiveByIds(ids);
    }

    /**
     * 删除事件接报信息
     * 
     * @param id 事件接报ID
     * @return 结果
     */
    @Override
    public int deleteTEventReceiveById(String id)
    {
        return tEventReceiveMapper.deleteTEventReceiveById(id);
    }

    @Override
    public List<TEventReceive> getReadReceiveList(Integer enterpriseId){
        return tEventReceiveMapper.getReadReceiveList(enterpriseId);
    }
}
