package com.zehong.system.service.impl;

import java.util.List;
import com.zehong.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TEventInfoMapper;
import com.zehong.system.domain.TEventInfo;
import com.zehong.system.service.ITEventInfoService;

/**
 * 事件处置Service业务层处理
 * 
 * @author zehong
 * @date 2022-02-11
 */
@Service
public class TEventInfoServiceImpl implements ITEventInfoService 
{
    @Autowired
    private TEventInfoMapper tEventInfoMapper;

    /**
     * 查询事件处置
     * 
     * @param eventId 事件处置ID
     * @return 事件处置
     */
    @Override
    public TEventInfo selectTEventInfoById(Long eventId)
    {
        return tEventInfoMapper.selectTEventInfoById(eventId);
    }

    /**
     * 查询事件处置列表
     * 
     * @param tEventInfo 事件处置
     * @return 事件处置
     */
    @Override
    public List<TEventInfo> selectTEventInfoList(TEventInfo tEventInfo)
    {
        return tEventInfoMapper.selectTEventInfoList(tEventInfo);
    }

    /**
     * 新增事件处置
     * 
     * @param tEventInfo 事件处置
     * @return 结果
     */
    @Override
    public int insertTEventInfo(TEventInfo tEventInfo)
    {
        tEventInfo.setCreateTime(DateUtils.getNowDate());
        return tEventInfoMapper.insertTEventInfo(tEventInfo);
    }

    /**
     * 修改事件处置
     * 
     * @param tEventInfo 事件处置
     * @return 结果
     */
    @Override
    public int updateTEventInfo(TEventInfo tEventInfo)
    {
        tEventInfo.setUpdateTime(DateUtils.getNowDate());
        return tEventInfoMapper.updateTEventInfo(tEventInfo);
    }

    /**
     * 批量删除事件处置
     * 
     * @param eventIds 需要删除的事件处置ID
     * @return 结果
     */
    @Override
    public int deleteTEventInfoByIds(Long[] eventIds)
    {
        return tEventInfoMapper.deleteTEventInfoByIds(eventIds);
    }

    /**
     * 删除事件处置信息
     * 
     * @param eventId 事件处置ID
     * @return 结果
     */
    @Override
    public int deleteTEventInfoById(Long eventId)
    {
        return tEventInfoMapper.deleteTEventInfoById(eventId);
    }
}
