package com.zehong.system.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TEmergencyDrillsMapper;
import com.zehong.system.domain.TEmergencyDrills;
import com.zehong.system.service.ITEmergencyDrillsService;

/**
 * 应急演练Service业务层处理
 * 
 * @author zehong
 * @date 2024-04-19
 */
@Service
public class TEmergencyDrillsServiceImpl implements ITEmergencyDrillsService 
{
    @Autowired
    private TEmergencyDrillsMapper tEmergencyDrillsMapper;

    /**
     * 查询应急演练
     * 
     * @param fDrillsId 应急演练ID
     * @return 应急演练
     */
    @Override
    public TEmergencyDrills selectTEmergencyDrillsById(Long fDrillsId)
    {
        return tEmergencyDrillsMapper.selectTEmergencyDrillsById(fDrillsId);
    }

    /**
     * 查询应急演练列表
     * 
     * @param tEmergencyDrills 应急演练
     * @return 应急演练
     */
    @Override
    public List<TEmergencyDrills> selectTEmergencyDrillsList(TEmergencyDrills tEmergencyDrills)
    {
        return tEmergencyDrillsMapper.selectTEmergencyDrillsList(tEmergencyDrills);
    }

    /**
     * 新增应急演练
     * 
     * @param tEmergencyDrills 应急演练
     * @return 结果
     */
    @Override
    public int insertTEmergencyDrills(TEmergencyDrills tEmergencyDrills)
    {
        return tEmergencyDrillsMapper.insertTEmergencyDrills(tEmergencyDrills);
    }

    /**
     * 修改应急演练
     * 
     * @param tEmergencyDrills 应急演练
     * @return 结果
     */
    @Override
    public int updateTEmergencyDrills(TEmergencyDrills tEmergencyDrills)
    {
        return tEmergencyDrillsMapper.updateTEmergencyDrills(tEmergencyDrills);
    }

    /**
     * 批量删除应急演练
     * 
     * @param fDrillsIds 需要删除的应急演练ID
     * @return 结果
     */
    @Override
    public int deleteTEmergencyDrillsByIds(Long[] fDrillsIds)
    {
        return tEmergencyDrillsMapper.deleteTEmergencyDrillsByIds(fDrillsIds);
    }

    /**
     * 删除应急演练信息
     * 
     * @param fDrillsId 应急演练ID
     * @return 结果
     */
    @Override
    public int deleteTEmergencyDrillsById(Long fDrillsId)
    {
        return tEmergencyDrillsMapper.deleteTEmergencyDrillsById(fDrillsId);
    }
}
