package com.zehong.system.service.impl;

import java.util.List;

import com.zehong.common.exception.CustomException;
import com.zehong.common.utils.StringUtils;
import com.zehong.system.domain.SysSetting;
import com.zehong.system.service.ISysSettingService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TCountyLevelRegionMapper;
import com.zehong.system.domain.TCountyLevelRegion;
import com.zehong.system.service.ITCountyLevelRegionService;

import javax.annotation.Resource;

/**
 * 县级行政区Service业务层处理
 * 
 * @author zehong
 * @date 2024-06-06
 */
@Service
public class TCountyLevelRegionServiceImpl implements ITCountyLevelRegionService 
{
    @Resource
    private TCountyLevelRegionMapper tCountyLevelRegionMapper;

    @Resource
    private ISysSettingService sysSettingService;

    /**
     * 查询县级行政区
     * 
     * @param fId 县级行政区ID
     * @return 县级行政区
     */
    @Override
    public TCountyLevelRegion selectTCountyLevelRegionById(Long fId)
    {
        return tCountyLevelRegionMapper.selectTCountyLevelRegionById(fId);
    }

    /**
     * 查询县级行政区列表
     * 
     * @param tCountyLevelRegion 县级行政区
     * @return 县级行政区
     */
    @Override
    public List<TCountyLevelRegion> selectTCountyLevelRegionList(TCountyLevelRegion tCountyLevelRegion)
    {
        return tCountyLevelRegionMapper.selectTCountyLevelRegionList(tCountyLevelRegion);
    }

    /**
     * 根据  县（市、区）行政区划编码 查询数据
     * @param countyCodes c
     * @return r
     */
    @Override
    public List<TCountyLevelRegion> queryByCountyCodes(List<String> countyCodes) {
        return tCountyLevelRegionMapper.queryByCountyCodes(countyCodes);
    }

    /**
     * 新增县级行政区
     * 
     * @param tCountyLevelRegion 县级行政区
     * @return 结果
     */
    @Override
    public int insertTCountyLevelRegion(TCountyLevelRegion tCountyLevelRegion)
    {
        return tCountyLevelRegionMapper.insertTCountyLevelRegion(tCountyLevelRegion);
    }

    /**
     * 修改县级行政区
     * 
     * @param tCountyLevelRegion 县级行政区
     * @return 结果
     */
    @Override
    public int updateTCountyLevelRegion(TCountyLevelRegion tCountyLevelRegion)
    {
        return tCountyLevelRegionMapper.updateTCountyLevelRegion(tCountyLevelRegion);
    }

    /**
     * 批量删除县级行政区
     * 
     * @param fIds 需要删除的县级行政区ID
     * @return 结果
     */
    @Override
    public int deleteTCountyLevelRegionByIds(Long[] fIds)
    {
        return tCountyLevelRegionMapper.deleteTCountyLevelRegionByIds(fIds);
    }

    /**
     * 删除县级行政区信息
     * 
     * @param fId 县级行政区ID
     * @return 结果
     */
    @Override
    public int deleteTCountyLevelRegionById(Long fId)
    {
        return tCountyLevelRegionMapper.deleteTCountyLevelRegionById(fId);
    }

    /**
     * 获取系统设置县
     * @return
     */
    @Override
    public List<TCountyLevelRegion> getDefaultCountyList() {
        SysSetting code = sysSettingService.getSystemValueByKey("city_id");
        if(null == code || StringUtils.isEmpty(code.getSystemValue())) throw new CustomException("市级行政编码未配置！");
        return tCountyLevelRegionMapper.queryByCityId(code.getSystemValue());
    }

}
