package com.zehong.system.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.zehong.common.core.domain.entity.SysRole;
import com.zehong.common.core.domain.model.LoginUser;
import com.zehong.common.exception.CustomException;
import com.zehong.common.utils.GovernmentDataCopyUtil;
import com.zehong.common.utils.GovernmentDataUtil;
import com.zehong.common.utils.SecurityUtils;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.system.domain.TConGasProInc;
import com.zehong.system.domain.TConGasProInfor;
import com.zehong.system.domain.vo.TConGasProIncVo;
import com.zehong.system.mapper.TConGasProIncMapper;
import com.zehong.system.service.ITConGasProIncService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 第三方施工-涉气第三方施工意外事件Service业务层处理
 * 
 * @author zehong
 * @date 2024-06-27
 */
@Service
public class TConGasProIncServiceImpl implements ITConGasProIncService 
{
    private static final Logger log = LoggerFactory.getLogger(TConGasProIncServiceImpl.class);

    @Resource
    private TConGasProIncMapper tConGasProIncMapper;

    @Resource
    private GovernmentDataUtil governmentDataUtil;


    /**
     * 查询第三方施工-涉气第三方施工意外事件
     * 
     * @param fConGasProIncId 第三方施工-涉气第三方施工意外事件ID
     * @return 第三方施工-涉气第三方施工意外事件
     */
    @Override
    public TConGasProInc selectTConGasProIncById(Long fConGasProIncId)
    {
        return tConGasProIncMapper.selectTConGasProIncById(fConGasProIncId);
    }

    /**
     * 查询第三方施工-涉气第三方施工意外事件列表
     * 
     * @param tConGasProInc 第三方施工-涉气第三方施工意外事件
     * @return 第三方施工-涉气第三方施工意外事件
     */
    @Override
    public List<TConGasProInc> selectTConGasProIncList(TConGasProInc tConGasProInc)
    {
        SysRole sysRole = SecurityUtils.getLoginUser().getUser().getRoles().get(0);
        // 不是超级管理员也不是企业
        if (sysRole.getRoleId() == 3) {
            tConGasProInc.setEntUploadState("1");
        }

        return tConGasProIncMapper.selectTConGasProIncList(tConGasProInc);
    }

    /**
     * 查询第三方施工-涉气第三方施工意外事件列表
     *
     * @param tConGasProInc 第三方施工-涉气第三方施工意外事件
     * @return 第三方施工-涉气第三方施工意外事件
     */
    @Override
    public List<TConGasProInc> exportTConGasProIncList(TConGasProInc tConGasProInc)
    {

        LoginUser loginUser = SecurityUtils.getLoginUser();

        if(loginUser.getUser().getRoles().get(0).getRoleId()==3){
            tConGasProInc.setEntUploadState("1");
            ExcelUtil.hiddencolumns.add(7);
            ExcelUtil.hiddencolumns.add(8);
        }

        if(loginUser.getUser().getRoles().get(0).getRoleId()==5){
            ExcelUtil.hiddencolumns.add(9);
            ExcelUtil.hiddencolumns.add(10);
        }

        return tConGasProIncMapper.selectTConGasProIncList(tConGasProInc);
    }


    /**
     * 新增第三方施工-涉气第三方施工意外事件
     * 
     * @param tConGasProInc 第三方施工-涉气第三方施工意外事件
     * @return 结果
     */
    @Override
    public int insertTConGasProInc(TConGasProInc tConGasProInc)
    {
        tConGasProInc.setfUpdateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        return tConGasProIncMapper.insertTConGasProInc(tConGasProInc);
    }

    /**
     * 修改第三方施工-涉气第三方施工意外事件
     * 
     * @param tConGasProInc 第三方施工-涉气第三方施工意外事件
     * @return 结果
     */
    @Override
    public int updateTConGasProInc(TConGasProInc tConGasProInc)
    {
        tConGasProInc.setfUpdateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        return tConGasProIncMapper.updateTConGasProInc(tConGasProInc);
    }

    /**
     * 批量删除第三方施工-涉气第三方施工意外事件
     * 
     * @param fConGasProIncIds 需要删除的第三方施工-涉气第三方施工意外事件ID
     * @return 结果
     */
    @Override
    public int deleteTConGasProIncByIds(Long[] fConGasProIncIds)
    {
        return tConGasProIncMapper.deleteTConGasProIncByIds(fConGasProIncIds);
    }

    /**
     * 删除第三方施工-涉气第三方施工意外事件信息
     * 
     * @param fConGasProIncId 第三方施工-涉气第三方施工意外事件ID
     * @return 结果
     */
    @Override
    public int deleteTConGasProIncById(Long fConGasProIncId)
    {
        return tConGasProIncMapper.deleteTConGasProIncById(fConGasProIncId);
    }

    /**
     * 上传第三方施工意外事件
     * @param fConGasProIncId 意外事件工id
     * @return
     */
    @Override
    public int reportAccidentInfo(Long fConGasProIncId) throws Exception {
        TConGasProInc conGasProInc = tConGasProIncMapper.selectTConGasProIncById(fConGasProIncId);
        TConGasProIncVo conGasProIncVo = new TConGasProIncVo();
        GovernmentDataCopyUtil.copyToGovernData(conGasProInc,conGasProIncVo);
        conGasProIncVo.setIntersectConstructionId(conGasProInc.getProjectCode());
        List<TConGasProIncVo> data = new ArrayList<>();
        data.add(conGasProIncVo);
        JSONObject reportResult = governmentDataUtil.setInfo("construction/gas/project/incident","WRITE",data);
        log.info("上传第三方施工意外事件结果===================" + reportResult.toJSONString());
        if(!"0".equals(reportResult.getString("resultCode"))) throw new CustomException("上传第三方施意外事件工接口失败");
        conGasProInc.setGovUploadState("1");
        conGasProInc.setGovUploadTime(new Date());
        tConGasProIncMapper.updateTConGasProInc(conGasProInc);
        return 1;
    }

    /**
     * 企业端上传
     * @param fConGasProIncId 意外事件工id
     * @return r
     */
    @Override
    public int entReportConGasProInfo(Long fConGasProIncId) {
        tConGasProIncMapper.updateEntUploadStateById("1",new Date(),fConGasProIncId);
        return 1;
    }
}
