package com.zehong.system.service;

import java.util.List;
import java.util.Map;

import com.zehong.system.domain.TWorkTask;

/**
 * 巡检巡查任务Service接口
 * 
 * @author zehong
 * @date 2023-09-14
 */
public interface ITWorkTaskService 
{
    /**
     * 查询巡检巡查任务
     * 
     * @param taskId 巡检巡查任务ID
     * @return 巡检巡查任务
     */
    public TWorkTask selectTWorkTaskById(Long taskId);

    /**
     * 查询巡检巡查任务列表
     * 
     * @param tWorkTask 巡检巡查任务
     * @return 巡检巡查任务集合
     */
    public List<TWorkTask> selectTWorkTaskList(TWorkTask tWorkTask);

    /**
     * 新增巡检巡查任务
     * 
     * @param tWorkTask 巡检巡查任务
     * @return 结果
     */
    public int insertTWorkTask(TWorkTask tWorkTask);

    /**
     * 修改巡检巡查任务
     * 
     * @param tWorkTask 巡检巡查任务
     * @return 结果
     */
    public int updateTWorkTask(TWorkTask tWorkTask);

    /**
     * 批量删除巡检巡查任务
     * 
     * @param taskIds 需要删除的巡检巡查任务ID
     * @return 结果
     */
    public int deleteTWorkTaskByIds(Long[] taskIds);

    /**
     * 删除巡检巡查任务信息
     * 
     * @param taskId 巡检巡查任务ID
     * @return 结果
     */
    public int deleteTWorkTaskById(Long taskId);

    /**
     * 小程序列表
     * @param tWorkTask
     * @return
     */
    public List<TWorkTask> selectTaskListxiao(TWorkTask tWorkTask);

    /**
     * 查询执行任务人员
     * @param taskId
     * @return
     */
    public Map<String,Object> selectPersonName(Long taskId);

    /**
     * 中途添加执行人
     * @param tWorkTask
     * @return
     */
    public Integer addmember(TWorkTask tWorkTask);
}
