package com.zehong.system.service;

import java.util.List;
import java.util.Map;

import com.zehong.system.domain.TWorkTaskPatrol;

/**
 * 巡线任务Service接口
 * 
 * @author zehong
 * @date 2023-09-15
 */
public interface ITWorkTaskPatrolService 
{
    /**
     * 查询巡线任务
     * 
     * @param patrolId 巡线任务ID
     * @return 巡线任务
     */
    public TWorkTaskPatrol selectTWorkTaskPatrolById(Long patrolId);

    /**
     * 查询巡线任务列表
     * 
     * @param tWorkTaskPatrol 巡线任务
     * @return 巡线任务集合
     */
    public List<TWorkTaskPatrol> selectTWorkTaskPatrolList(TWorkTaskPatrol tWorkTaskPatrol);

    /**
     * 新增巡线任务
     * 
     * @param tWorkTaskPatrol 巡线任务
     * @return 结果
     */
    public int insertTWorkTaskPatrol(TWorkTaskPatrol tWorkTaskPatrol);

    /**
     * 修改巡线任务
     * 
     * @param tWorkTaskPatrol 巡线任务
     * @return 结果
     */
    public int updateTWorkTaskPatrol(TWorkTaskPatrol tWorkTaskPatrol);
    public int updatebytmid(TWorkTaskPatrol tWorkTaskPatrol);

    /**
     * 批量删除巡线任务
     * 
     * @param patrolIds 需要删除的巡线任务ID
     * @return 结果
     */
    public int deleteTWorkTaskPatrolByIds(Long[] patrolIds);

    /**
     * 删除巡线任务信息
     * 
     * @param patrolId 巡线任务ID
     * @return 结果
     */
    public int deleteTWorkTaskPatrolById(Long patrolId);

    /**
     * 巡检统计
     * @param tWorkTaskPatrol 巡检实体
     * @return
     */
    List<Map<String,Object>> patrolStatistic(TWorkTaskPatrol tWorkTaskPatrol);
}
