package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TTransferPostRecord;

/**
 * 调岗记录Service接口
 * 
 * @author zehong
 * @date 2023-09-21
 */
public interface ITTransferPostRecordService 
{
    /**
     * 查询调岗记录
     * 
     * @param recordId 调岗记录ID
     * @return 调岗记录
     */
    public TTransferPostRecord selectTTransferPostRecordById(Long recordId);

    /**
     * 查询调岗记录列表
     * 
     * @param tTransferPostRecord 调岗记录
     * @return 调岗记录集合
     */
    public List<TTransferPostRecord> selectTTransferPostRecordList(TTransferPostRecord tTransferPostRecord);
    public List<TTransferPostRecord> xiaolist(TTransferPostRecord tTransferPostRecord);
    /**
     * 新增调岗记录
     * 
     * @param tTransferPostRecord 调岗记录
     * @return 结果
     */
    public int insertTTransferPostRecord(TTransferPostRecord tTransferPostRecord);

    /**
     * 修改调岗记录
     * 
     * @param tTransferPostRecord 调岗记录
     * @return 结果
     */
    public int updateTTransferPostRecord(TTransferPostRecord tTransferPostRecord);

    /**
     * 批量删除调岗记录
     * 
     * @param recordIds 需要删除的调岗记录ID
     * @return 结果
     */
    public int deleteTTransferPostRecordByIds(Long[] recordIds);

    /**
     * 删除调岗记录信息
     * 
     * @param recordId 调岗记录ID
     * @return 结果
     */
    public int deleteTTransferPostRecordById(Long recordId);
}
