package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TTrainPerson;

/**
 * 燃气培训人员Service接口
 * 
 * @author zehong
 * @date 2023-04-22
 */
public interface ITTrainPersonService 
{
    /**
     * 查询燃气培训人员
     * 
     * @param id 燃气培训人员ID
     * @return 燃气培训人员
     */
    public TTrainPerson selectTTrainPersonById(Long id);

    /**
     * 查询燃气培训人员列表
     * 
     * @param tTrainPerson 燃气培训人员
     * @return 燃气培训人员集合
     */
    public List<TTrainPerson> selectTTrainPersonList(TTrainPerson tTrainPerson);

    /**
     * 新增燃气培训人员
     * 
     * @param tTrainPerson 燃气培训人员
     * @return 结果
     */
    public int insertTTrainPerson(TTrainPerson tTrainPerson);

    /**
     * 修改燃气培训人员
     * 
     * @param tTrainPerson 燃气培训人员
     * @return 结果
     */
    public int updateTTrainPerson(TTrainPerson tTrainPerson);

    /**
     * 批量删除燃气培训人员
     * 
     * @param ids 需要删除的燃气培训人员ID
     * @return 结果
     */
    public int deleteTTrainPersonByIds(Long[] ids);

    /**
     * 删除燃气培训人员信息
     * 
     * @param id 燃气培训人员ID
     * @return 结果
     */
    public int deleteTTrainPersonById(Long id);
}
