package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TSupervisorInfo;

/**
 * 燃气督办Service接口
 * 
 * @author zehong
 * @date 2022-03-31
 */
public interface ITSupervisorInfoService 
{
    /**
     * 查询燃气督办
     * 
     * @param supervisorId 燃气督办ID
     * @return 燃气督办
     */
    public TSupervisorInfo selectTSupervisorInfoById(Long supervisorId);

    /**
     * 查询燃气督办列表
     * 
     * @param tSupervisorInfo 燃气督办
     * @return 燃气督办集合
     */
    public List<TSupervisorInfo> selectTSupervisorInfoList(TSupervisorInfo tSupervisorInfo);

    /**
     * 新增燃气督办
     * 
     * @param tSupervisorInfo 燃气督办
     * @return 结果
     */
    public int insertTSupervisorInfo(TSupervisorInfo tSupervisorInfo);

    /**
     * 修改燃气督办
     * 
     * @param tSupervisorInfo 燃气督办
     * @return 结果
     */
    public int updateTSupervisorInfo(TSupervisorInfo tSupervisorInfo);

    /**
     * 批量删除燃气督办
     * 
     * @param supervisorIds 需要删除的燃气督办ID
     * @return 结果
     */
    public int deleteTSupervisorInfoByIds(Long[] supervisorIds);

    /**
     * 删除燃气督办信息
     * 
     * @param supervisorId 燃气督办ID
     * @return 结果
     */
    public int deleteTSupervisorInfoById(Long supervisorId);
}
