package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TSupervise;

/**
 * 监督检查Service接口
 * 
 * @author zehong
 * @date 2024-02-04
 */
public interface ITSuperviseService 
{
    /**
     * 查询监督检查
     * 
     * @param id 监督检查ID
     * @return 监督检查
     */
    public TSupervise selectTSuperviseById(Long id);

    /**
     * 查询监督检查列表
     * 
     * @param tSupervise 监督检查
     * @return 监督检查集合
     */
    public List<TSupervise> selectTSuperviseList(TSupervise tSupervise);

    /**
     * 新增监督检查
     * 
     * @param tSupervise 监督检查
     * @return 结果
     */
    public int insertTSupervise(TSupervise tSupervise);

    /**
     * 修改监督检查
     * 
     * @param tSupervise 监督检查
     * @return 结果
     */
    public int updateTSupervise(TSupervise tSupervise);

    /**
     * 批量删除监督检查
     * 
     * @param ids 需要删除的监督检查ID
     * @return 结果
     */
    public int deleteTSuperviseByIds(Long[] ids);

    /**
     * 删除监督检查信息
     * 
     * @param id 监督检查ID
     * @return 结果
     */
    public int deleteTSuperviseById(Long id);
}
