package com.zehong.system.service;

import java.util.List;

import com.zehong.system.domain.TSupBalGasSup;
import com.zehong.system.domain.TSupBalUsgDay;

/**
 * 供需平衡-企业每日填报Service接口
 * 
 * @author zehong
 * @date 2024-06-25
 */
public interface ITSupBalUsgDayService 
{
    /**
     * 查询供需平衡-企业每日填报
     * 
     * @param fRepUsgDayId 供需平衡-企业每日填报ID
     * @return 供需平衡-企业每日填报
     */
    public TSupBalUsgDay selectTSupBalUsgDayById(Long fRepUsgDayId);

    /**
     * 查询供需平衡-企业每日填报列表
     * 
     * @param tSupBalUsgDay 供需平衡-企业每日填报
     * @return 供需平衡-企业每日填报集合
     */
    public List<TSupBalUsgDay> selectTSupBalUsgDayList(TSupBalUsgDay tSupBalUsgDay);

    /**
     * 新增供需平衡-企业每日填报
     * 
     * @param tSupBalUsgDay 供需平衡-企业每日填报
     * @return 结果
     */
    public int insertTSupBalUsgDay(TSupBalUsgDay tSupBalUsgDay);

    /**
     * 修改供需平衡-企业每日填报
     * 
     * @param tSupBalUsgDay 供需平衡-企业每日填报
     * @return 结果
     */
    public int updateTSupBalUsgDay(TSupBalUsgDay tSupBalUsgDay);

    /**
     * 批量删除供需平衡-企业每日填报
     * 
     * @param fRepUsgDayIds 需要删除的供需平衡-企业每日填报ID
     * @return 结果
     */
    public int deleteTSupBalUsgDayByIds(Long[] fRepUsgDayIds);

    /**
     * 删除供需平衡-企业每日填报信息
     * 
     * @param fRepUsgDayId 供需平衡-企业每日填报ID
     * @return 结果
     */
    public int deleteTSupBalUsgDayById(Long fRepUsgDayId);

    /**
     * 获取上报信息
     * @param companyId 企业id
     * @param calendarDate 上报时间
     * @return
     */
    TSupBalUsgDay getReportInfoByCompany(String companyId, String calendarDate);

    /**
     * 上传日用气量记录
     * @param fRepUsgDayId 监管记录主键
     * @return
     */
    int reportSupBalGasDayRecInfo(Long fRepUsgDayId);
}
