package com.zehong.system.service;

import java.util.HashMap;
import java.util.List;
import com.zehong.system.domain.TLpgSafeCheckRecord;
import com.zehong.system.domain.vo.TLpgSafeCheckRecordImportVo;

import javax.servlet.http.HttpServletResponse;

/**
 * 液化石油安检记录Service接口
 * 
 * @author zehong
 * @date 2024-07-22
 */
public interface ITLpgSafeCheckRecordService 
{
    /**
     * 查询液化石油安检记录
     * 
     * @param safeCheckId 液化石油安检记录ID
     * @return 液化石油安检记录
     */
    public TLpgSafeCheckRecord selectTLpgSafeCheckRecordById(Long safeCheckId);

    /**
     * 查询液化石油安检记录列表
     * 
     * @param tLpgSafeCheckRecord 液化石油安检记录
     * @return 液化石油安检记录集合
     */
    public List<TLpgSafeCheckRecord> selectTLpgSafeCheckRecordList(TLpgSafeCheckRecord tLpgSafeCheckRecord);

    /**
     * 新增液化石油安检记录
     * 
     * @param tLpgSafeCheckRecord 液化石油安检记录
     * @return 结果
     */
    public int insertTLpgSafeCheckRecord(TLpgSafeCheckRecord tLpgSafeCheckRecord);

    /**
     * 批量插入
     * @param tLpgSafeCheckRecords t
     * @return r
     */
    public int insertBatchContainPic(List<TLpgSafeCheckRecord> tLpgSafeCheckRecords);

    /**
     * 修改液化石油安检记录
     * 
     * @param tLpgSafeCheckRecord 液化石油安检记录
     * @return 结果
     */
    public int updateTLpgSafeCheckRecord(TLpgSafeCheckRecord tLpgSafeCheckRecord);

    /**
     * 批量删除液化石油安检记录
     * 
     * @param safeCheckIds 需要删除的液化石油安检记录ID
     * @return 结果
     */
    public int deleteTLpgSafeCheckRecordByIds(Long[] safeCheckIds);

    /**
     * 导入
     * @param XmbhList data
     * @param updateSupport 是否更新
     * @param response res
     * @return r
     */
    public HashMap<String, Object> importLpgSafeCheckRecordInfo(List<TLpgSafeCheckRecordImportVo> XmbhList,boolean updateSupport,String deptId,HttpServletResponse response);
    /**
     * 删除液化石油安检记录信息
     * 
     * @param safeCheckId 液化石油安检记录ID
     * @return 结果
     */
    public int deleteTLpgSafeCheckRecordById(Long safeCheckId);
}
