package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TInsTaskInfor;

/**
 * 监督检查-检查任务Service接口
 * 
 * @author zehong
 * @date 2024-05-16
 */
public interface ITInsTaskInforService 
{
    /**
     * 查询监督检查-检查任务
     * 
     * @param fInsTaskInforId 监督检查-检查任务ID
     * @return 监督检查-检查任务
     */
    public TInsTaskInfor selectTInsTaskInforById(Long fInsTaskInforId);

    /**
     * 查询监督检查-检查任务列表
     * 
     * @param tInsTaskInfor 监督检查-检查任务
     * @return 监督检查-检查任务集合
     */
    public List<TInsTaskInfor> selectTInsTaskInforList(TInsTaskInfor tInsTaskInfor);

    /**
     * 新增监督检查-检查任务
     * 
     * @param tInsTaskInfor 监督检查-检查任务
     * @return 结果
     */
    public int insertTInsTaskInfor(TInsTaskInfor tInsTaskInfor);

    /**
     * 修改监督检查-检查任务
     * 
     * @param tInsTaskInfor 监督检查-检查任务
     * @return 结果
     */
    public int updateTInsTaskInfor(TInsTaskInfor tInsTaskInfor);

    /**
     * 批量删除监督检查-检查任务
     * 
     * @param fInsTaskInforIds 需要删除的监督检查-检查任务ID
     * @return 结果
     */
    public int deleteTInsTaskInforByIds(Long[] fInsTaskInforIds);

    /**
     * 删除监督检查-检查任务信息
     * 
     * @param fInsTaskInforId 监督检查-检查任务ID
     * @return 结果
     */
    public int deleteTInsTaskInforById(Long fInsTaskInforId);
}
