package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TGasuserSafetyDeviceInfo;

/**
 * 用户管理-燃气用户-安全装置加装维护Service接口
 * 
 * @author zehong
 * @date 2024-08-27
 */
public interface ITGasuserSafetyDeviceInfoService 
{
    /**
     * 查询用户管理-燃气用户-安全装置加装维护
     * 
     * @param gasUserSafetyDeviceId 用户管理-燃气用户-安全装置加装维护ID
     * @return 用户管理-燃气用户-安全装置加装维护
     */
    public TGasuserSafetyDeviceInfo selectTGasuserSafetyDeviceInfoById(Long gasUserSafetyDeviceId);

    /**
     * 查询用户管理-燃气用户-安全装置加装维护列表
     * 
     * @param tGasuserSafetyDeviceInfo 用户管理-燃气用户-安全装置加装维护
     * @return 用户管理-燃气用户-安全装置加装维护集合
     */
    public List<TGasuserSafetyDeviceInfo> selectTGasuserSafetyDeviceInfoList(TGasuserSafetyDeviceInfo tGasuserSafetyDeviceInfo);



    /**
     * 查询用户管理-燃气用户-安全装置加装维护列表-燃气用户界面使用
     *
     * @param tGasuserSafetyDeviceInfo 用户管理-燃气用户-安全装置加装维护
     * @return 用户管理-燃气用户-安全装置加装维护集合
     */
    public List<TGasuserSafetyDeviceInfo> queryNoSelectSafeDeviceInfoList(TGasuserSafetyDeviceInfo tGasuserSafetyDeviceInfo);
    /**
     * 新增用户管理-燃气用户-安全装置加装维护
     * 
     * @param tGasuserSafetyDeviceInfo 用户管理-燃气用户-安全装置加装维护
     * @return 结果
     */
    public int insertTGasuserSafetyDeviceInfo(TGasuserSafetyDeviceInfo tGasuserSafetyDeviceInfo);

    /**
     * 修改用户管理-燃气用户-安全装置加装维护
     * 
     * @param tGasuserSafetyDeviceInfo 用户管理-燃气用户-安全装置加装维护
     * @return 结果
     */
    public int updateTGasuserSafetyDeviceInfo(TGasuserSafetyDeviceInfo tGasuserSafetyDeviceInfo);

    /**
     * 批量删除用户管理-燃气用户-安全装置加装维护
     * 
     * @param gasUserSafetyDeviceIds 需要删除的用户管理-燃气用户-安全装置加装维护ID
     * @return 结果
     */
    public int deleteTGasuserSafetyDeviceInfoByIds(Long[] gasUserSafetyDeviceIds);

    /**
     * 关联设备数据删除接口
     * @param deviceIds
     */
    void deleteSafetyDeviceListInfo(Long[] deviceIds);

    /**
     * 关联设备数据删除接口
     * @param deviceId
     */
    void deleteSafetyDeviceInfo(Long deviceId);

    /**
     * 根据 燃气用户id 查询数据
     * @param userId
     * @return
     */
    List<TGasuserSafetyDeviceInfo> selectSafetyDeviceDetailInfoList(Long userId);
    /**
     * 删除用户管理-燃气用户-安全装置加装维护信息
     * 
     * @param gasUserSafetyDeviceId 用户管理-燃气用户-安全装置加装维护ID
     * @return 结果
     */
    public int deleteTGasuserSafetyDeviceInfoById(Long gasUserSafetyDeviceId);
}
