package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TEnterpriseInfo;
import com.zehong.system.domain.vo.TEnterpriseInfoVO;

/**
 * 企业信息Service接口
 *
 * @author zehong
 * @date 2022-01-24
 */
public interface ITEnterpriseInfoService
{
    /**
     * 查询企业信息
     *
     * @param enterpriseId 企业信息ID
     * @return 企业信息
     */
    public TEnterpriseInfo selectTEnterpriseInfoById(String enterpriseId);

    public List<TEnterpriseInfoVO> enterpriseInfoList(TEnterpriseInfo tEnterpriseInfo);

    /**
     * 查询企业信息列表
     *
     * @param tEnterpriseInfo 企业信息
     * @return 企业信息集合
     */
    public List<TEnterpriseInfo> selectTEnterpriseInfoList(TEnterpriseInfo tEnterpriseInfo);

    /**
     * 无条件查询所有企业
     */
    public List<TEnterpriseInfo> queryAllEnterprise();

    /**
     * 新增企业信息
     *
     * @param tEnterpriseInfo 企业信息
     * @return 结果
     */
    public int insertTEnterpriseInfo(TEnterpriseInfo tEnterpriseInfo);

    /**
     * 修改企业信息
     *
     * @param tEnterpriseInfo 企业信息
     * @return 结果
     */
    public int updateTEnterpriseInfo(TEnterpriseInfo tEnterpriseInfo);

    /**
     * 批量删除企业信息
     *
     * @param enterpriseIds 需要删除的企业信息ID
     * @return 结果
     */
    public int deleteTEnterpriseInfoByIds(String[] enterpriseIds);

    /**
     * 删除企业信息信息
     *
     * @param enterpriseId 企业信息ID
     * @return 结果
     */
    public int deleteTEnterpriseInfoById(String enterpriseId);

    /**
     * 导入企业信息
     *
     * @param XmbhList 用户数据列表
     * @param isUpdateSupport 是否更新支持，如果已存在，则进行更新数据
     * @param operName 操作用户
     * @return 结果
     */
    public String importEnterpriseInfo(List<TEnterpriseInfo> XmbhList, Boolean isUpdateSupport, String operName);


}
