package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TEmployedPeopleInfo;
import com.zehong.system.domain.TEmployedPeopleInfoError;
import com.zehong.system.domain.TEnterpriseInfo;

import javax.servlet.http.HttpServletResponse;

/**
 * 从业人员信息Service接口
 *
 * @author zehong
 * @date 2022-01-25
 */
public interface ITEmployedPeopleInfoService
{
    /**
     * 查询从业人员信息
     *
     * @param employedPeopleId 从业人员信息ID
     * @return 从业人员信息
     */
    public TEmployedPeopleInfo selectTEmployedPeopleInfoById(Long employedPeopleId);

    /**
     * 查询从业人员信息列表
     *
     * @param tEmployedPeopleInfo 从业人员信息
     * @return 从业人员信息集合
     */
    public List<TEmployedPeopleInfo> selectTEmployedPeopleInfoList(TEmployedPeopleInfo tEmployedPeopleInfo);

    /**
     * 新增从业人员信息
     *
     * @param tEmployedPeopleInfo 从业人员信息
     * @return 结果
     */
    public int insertTEmployedPeopleInfo(TEmployedPeopleInfo tEmployedPeopleInfo);

    /**
     * 修改从业人员信息
     *
     * @param tEmployedPeopleInfo 从业人员信息
     * @return 结果
     */
    public int updateTEmployedPeopleInfo(TEmployedPeopleInfo tEmployedPeopleInfo);

    /**
     * 批量删除从业人员信息
     *
     * @param employedPeopleIds 需要删除的从业人员信息ID
     * @return 结果
     */
    public int deleteTEmployedPeopleInfoByIds(Long[] employedPeopleIds);

    /**
     * 删除从业人员信息信息
     *
     * @param employedPeopleId 从业人员信息ID
     * @return 结果
     */
    public int deleteTEmployedPeopleInfoById(Long employedPeopleId);

    /**
     * 企业信息查询(下拉框数据)
     * @return
     */
    public List<TEnterpriseInfo> selectTEnterprise(String deptId);

    /**
     * 根据企业id查询企业名称
     * @return
     */
    String selectEnterpriseName(String bId);

    /**
     * 导入企业信息
     *
     * @param XmbhList 用户数据列表
     * @param isUpdateSupport 是否更新支持，如果已存在，则进行更新数据
     * @param operName 操作用户
     * @return 结果
     */
    public String importEmployedPeopleInfo(List<TEmployedPeopleInfoError> XmbhList, Boolean isUpdateSupport, String operName, HttpServletResponse response);

    /**
     * 查询当前用户导入 从业人员的错误数据总数
     * @return
     */
    public int countImportError();


    /**
     * 查询 人员类型 分组
     * @return r
     */
    public List<String> queryPeopleOccupationByGroupBy();
}
