package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TDoubleBook;

/**
 * 双代台账Service接口
 * 
 * @author zehong
 * @date 2024-04-21
 */
public interface ITDoubleBookService 
{
    /**
     * 查询双代台账
     * 
     * @param bookId 双代台账ID
     * @return 双代台账
     */
    public TDoubleBook selectTDoubleBookById(Long bookId);

    /**
     * 查询双代台账列表
     * 
     * @param tDoubleBook 双代台账
     * @return 双代台账集合
     */
    public List<TDoubleBook> selectTDoubleBookList(TDoubleBook tDoubleBook);

    /**
     * 导出双代台账列表
     *
     * @param tDoubleBook 双代台账
     * @return 双代台账集合
     */
    public List<TDoubleBook> exportTDoubleBookList(TDoubleBook tDoubleBook);

    /**
     * 新增双代台账
     * 
     * @param tDoubleBook 双代台账
     * @return 结果
     */
    public int insertTDoubleBook(TDoubleBook tDoubleBook);

    /**
     * 修改双代台账
     * 
     * @param tDoubleBook 双代台账
     * @return 结果
     */
    public int updateTDoubleBook(TDoubleBook tDoubleBook);

    /**
     * 批量删除双代台账
     * 
     * @param bookIds 需要删除的双代台账ID
     * @return 结果
     */
    public int deleteTDoubleBookByIds(Long[] bookIds);

    /**
     * 删除双代台账信息
     * 
     * @param bookId 双代台账ID
     * @return 结果
     */
    public int deleteTDoubleBookById(Long bookId);
}
