package com.zehong.system.service;

import java.io.IOException;
import java.util.List;
import java.util.Map;

import com.zehong.system.domain.TComplainDeal;
import com.zehong.system.domain.vo.ComplainDealSummaryAnalysisTableVo;
import com.zehong.system.domain.vo.ComplainDealSummaryAnalysisVo;
import com.zehong.system.domain.vo.HomepageVo;

import javax.servlet.http.HttpServletResponse;

/**
 * 投诉处置Service接口
 * 
 * @author zehong
 * @date 2022-02-15
 */
public interface ITComplainDealService 
{
    /**
     * 查询投诉处置
     * 
     * @param complainDealId 投诉处置ID
     * @return 投诉处置
     */
    public TComplainDeal selectTComplainDealById(Long complainDealId);

    /**
     * 查询投诉处置列表
     * 
     * @param tComplainDeal 投诉处置
     * @return 投诉处置集合
     */
    public List<TComplainDeal> selectTComplainDealList(TComplainDeal tComplainDeal);

    /**
     * 投诉处置统计
     *
     * @return 投诉处置统计
     */
    public HomepageVo countTComplainDeal();

    /**
     * 新增投诉处置
     * 
     * @param tComplainDeal 投诉处置
     * @return 结果
     */
    public int insertTComplainDeal(TComplainDeal tComplainDeal);

    /**
     * 修改投诉处置
     * 
     * @param tComplainDeal 投诉处置
     * @return 结果
     */
    public int updateTComplainDeal(TComplainDeal tComplainDeal);

    /**
     * 批量删除投诉处置
     * 
     * @param complainDealIds 需要删除的投诉处置ID
     * @return 结果
     */
    public int deleteTComplainDealByIds(Long[] complainDealIds);

    /**
     * 删除投诉处置信息
     * 
     * @param complainDealId 投诉处置ID
     * @return 结果
     */
    public int deleteTComplainDealById(Long complainDealId);

    public List<Map<String,Object>> selectUserByenterproseId(String enterproseId);

    public ComplainDealSummaryAnalysisVo complainDealSummaryAnalysisMethod();


    /**
     *
     * @param dataSourceName ureport2配置数据源名称
     * @param dataSetName ureport2配置数据集明恒
     * @param map 参数map
     * @return
     */
    public List<ComplainDealSummaryAnalysisTableVo> complainDealSummaryAnalysisMethodTableViewsForUrepore2(String dataSourceName,String dataSetName,Map<String,String> map);

    public List<ComplainDealSummaryAnalysisTableVo> complainDealSummaryAnalysisMethodTableViews(ComplainDealSummaryAnalysisTableVo complainDealSummaryAnalysisTableVo);


    public void complainDealSummaryAnalysisExport(HttpServletResponse httpServletResponse, ComplainDealSummaryAnalysisTableVo complainDealSummaryAnalysisTableVo) throws IOException;

}
