package com.zehong.system.service;

import com.zehong.system.domain.TComplainDealManSysSet;

import java.util.List;

/**
 * 燃气投诉处置的管理制度维护Service接口
 * 
 * @author zehong
 * @date 2024-06-05
 */
public interface ITComplainDealManSysSetService 
{
    /**
     * 查询燃气投诉处置的管理制度维护
     * 
     * @param fComplainDealManSysSetId 燃气投诉处置的管理制度维护ID
     * @return 燃气投诉处置的管理制度维护
     */
    public TComplainDealManSysSet selectTComplainDealManSysSetById(Long fComplainDealManSysSetId);

    /**
     * 查询燃气投诉处置的管理制度维护列表
     * 
     * @param tComplainDealManSysSet 燃气投诉处置的管理制度维护
     * @return 燃气投诉处置的管理制度维护集合
     */
    public List<TComplainDealManSysSet> selectTComplainDealManSysSetList(TComplainDealManSysSet tComplainDealManSysSet);

    /**
     * 批量修改
     * @param tComplainDealManSysSets s
     */
    public void batchUpdate(List<TComplainDealManSysSet> tComplainDealManSysSets);

    /**
     * 新增燃气投诉处置的管理制度维护
     * 
     * @param tComplainDealManSysSet 燃气投诉处置的管理制度维护
     * @return 结果
     */
    public int insertTComplainDealManSysSet(TComplainDealManSysSet tComplainDealManSysSet);

    /**
     * 修改燃气投诉处置的管理制度维护
     * 
     * @param tComplainDealManSysSet 燃气投诉处置的管理制度维护
     * @return 结果
     */
    public int updateTComplainDealManSysSet(TComplainDealManSysSet tComplainDealManSysSet);

    /**
     * 批量删除燃气投诉处置的管理制度维护
     * 
     * @param fComplainDealManSysSetIds 需要删除的燃气投诉处置的管理制度维护ID
     * @return 结果
     */
    public int deleteTComplainDealManSysSetByIds(Long[] fComplainDealManSysSetIds);

    /**
     * 删除燃气投诉处置的管理制度维护信息
     * 
     * @param fComplainDealManSysSetId 燃气投诉处置的管理制度维护ID
     * @return 结果
     */
    public int deleteTComplainDealManSysSetById(Long fComplainDealManSysSetId);
}
