package com.zehong.system.service;

import com.zehong.system.domain.TComplainDealEvaluate;

import java.util.List;

/**
 * 燃气投诉处置-评价Service接口
 * 
 * @author zehong
 * @date 2024-06-06
 */
public interface ITComplainDealEvaluateService 
{
    /**
     * 查询燃气投诉处置-评价
     * 
     * @param complainDealEvaluateId 燃气投诉处置-评价ID
     * @return 燃气投诉处置-评价
     */
    public TComplainDealEvaluate selectTComplainDealEvaluateById(Long complainDealEvaluateId);

    /**
     * 查询燃气投诉处置-评价
     *
     * @param complainDealId 燃气投诉处置
     * @return 燃气投诉处置-评价
     */
    public TComplainDealEvaluate selectTComplainDealEvaluateByComplainDealId(Long complainDealId);

    /**
     * 查询燃气投诉处置-评价列表
     * 
     * @param tComplainDealEvaluate 燃气投诉处置-评价
     * @return 燃气投诉处置-评价集合
     */
    public List<TComplainDealEvaluate> selectTComplainDealEvaluateList(TComplainDealEvaluate tComplainDealEvaluate);

    /**
     * 新增燃气投诉处置-评价
     * 
     * @param tComplainDealEvaluate 燃气投诉处置-评价
     * @return 结果
     */
    public int insertTComplainDealEvaluate(TComplainDealEvaluate tComplainDealEvaluate);

    /**
     * 修改燃气投诉处置-评价
     * 
     * @param tComplainDealEvaluate 燃气投诉处置-评价
     * @return 结果
     */
    public int updateTComplainDealEvaluate(TComplainDealEvaluate tComplainDealEvaluate);

    /**
     * 批量删除燃气投诉处置-评价
     * 
     * @param complainDealEvaluateIds 需要删除的燃气投诉处置-评价ID
     * @return 结果
     */
    public int deleteTComplainDealEvaluateByIds(Long[] complainDealEvaluateIds);

    /**
     * 删除燃气投诉处置-评价信息
     * 
     * @param complainDealEvaluateId 燃气投诉处置-评价ID
     * @return 结果
     */
    public int deleteTComplainDealEvaluateById(Long complainDealEvaluateId);
}
