package com.zehong.system.mapper;

import java.util.List;
import java.util.Map;

import com.zehong.system.domain.TWorkTask;

/**
 * 巡检巡查任务Mapper接口
 * 
 * @author zehong
 * @date 2023-09-14
 */
public interface TWorkTaskMapper 
{
    /**
     * 查询巡检巡查任务
     * 
     * @param taskId 巡检巡查任务ID
     * @return 巡检巡查任务
     */
    public TWorkTask selectTWorkTaskById(Long taskId);

    /**
     * 查询巡检巡查任务列表
     * 
     * @param tWorkTask 巡检巡查任务
     * @return 巡检巡查任务集合
     */
    public List<TWorkTask> selectTWorkTaskList(TWorkTask tWorkTask);

    /**
     * 新增巡检巡查任务
     * 
     * @param tWorkTask 巡检巡查任务
     * @return 结果
     */
    public int insertTWorkTask(TWorkTask tWorkTask);

    /**
     * 修改巡检巡查任务
     * 
     * @param tWorkTask 巡检巡查任务
     * @return 结果
     */
    public int updateTWorkTask(TWorkTask tWorkTask);

    /**
     * 删除巡检巡查任务
     * 
     * @param taskId 巡检巡查任务ID
     * @return 结果
     */
    public int deleteTWorkTaskById(Long taskId);

    /**
     * 批量删除巡检巡查任务
     * 
     * @param taskIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTWorkTaskByIds(Long[] taskIds);

    /**
     * 小程序查询巡检巡查任务列表
     *
     * @param tWorkTask 巡检巡查任务
     * @return 巡检巡查任务集合
     */
    public List<TWorkTask> selectTaskListxiao(TWorkTask tWorkTask);

    public Map<String,Object> selectPersonName(Long taskId);

}
