package com.zehong.system.mapper;

import com.zehong.system.domain.TVehicleUseRecord;

import java.util.List;

/**
 * 车辆使用记录Mapper接口
 * 
 * @author zehong
 * @date 2023-08-19
 */
public interface TVehicleUseRecordMapper 
{
    /**
     * 查询车辆使用记录
     * 
     * @param vehicleUseRecordId 车辆使用记录ID
     * @return 车辆使用记录
     */
    public TVehicleUseRecord selectTVehicleUseRecordById(Long vehicleUseRecordId);

    /**
     * 查询车辆使用记录列表
     * 
     * @param tVehicleUseRecord 车辆使用记录
     * @return 车辆使用记录集合
     */
    public List<TVehicleUseRecord> selectTVehicleUseRecordList(TVehicleUseRecord tVehicleUseRecord);

    /**
     * 新增车辆使用记录
     * 
     * @param tVehicleUseRecord 车辆使用记录
     * @return 结果
     */
    public int insertTVehicleUseRecord(TVehicleUseRecord tVehicleUseRecord);

    /**
     * 修改车辆使用记录
     * 
     * @param tVehicleUseRecord 车辆使用记录
     * @return 结果
     */
    public int updateTVehicleUseRecord(TVehicleUseRecord tVehicleUseRecord);

    /**
     * 删除车辆使用记录
     * 
     * @param vehicleUseRecordId 车辆使用记录ID
     * @return 结果
     */
    public int deleteTVehicleUseRecordById(Long vehicleUseRecordId);

    /**
     * 批量删除车辆使用记录
     * 
     * @param vehicleUseRecordIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTVehicleUseRecordByIds(Long[] vehicleUseRecordIds);
}
