package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TProAppInfor;

/**
 * 行业专家库-专家申报Mapper接口
 * 
 * @author zehong
 * @date 2024-05-06
 */
public interface TProAppInforMapper 
{
    /**
     * 查询行业专家库-专家申报
     * 
     * @param fProAppInforId 行业专家库-专家申报ID
     * @return 行业专家库-专家申报
     */
    public TProAppInfor selectTProAppInforById(Long fProAppInforId);

    /**
     * 查询行业专家库-专家申报列表
     * 
     * @param tProAppInfor 行业专家库-专家申报
     * @return 行业专家库-专家申报集合
     */
    public List<TProAppInfor> selectTProAppInforList(TProAppInfor tProAppInfor);

    /**
     * 新增行业专家库-专家申报
     * 
     * @param tProAppInfor 行业专家库-专家申报
     * @return 结果
     */
    public int insertTProAppInfor(TProAppInfor tProAppInfor);

    /**
     * 修改行业专家库-专家申报
     * 
     * @param tProAppInfor 行业专家库-专家申报
     * @return 结果
     */
    public int updateTProAppInfor(TProAppInfor tProAppInfor);

    /**
     * 删除行业专家库-专家申报
     * 
     * @param fProAppInforId 行业专家库-专家申报ID
     * @return 结果
     */
    public int deleteTProAppInforById(Long fProAppInforId);

    /**
     * 批量删除行业专家库-专家申报
     * 
     * @param fProAppInforIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTProAppInforByIds(Long[] fProAppInforIds);
}
