package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TLpgGasBottleFiles;
import org.apache.ibatis.annotations.Param;

/**
 * 液化石油气-气瓶档案Mapper接口
 * 
 * @author zehong
 * @date 2024-07-09
 */
public interface TLpgGasBottleFilesMapper 
{
    /**
     * 查询液化石油气-气瓶档案
     * 
     * @param fGasBottleFilesId 液化石油气-气瓶档案ID
     * @return 液化石油气-气瓶档案
     */
    public TLpgGasBottleFiles selectTLpgGasBottleFilesById(Long fGasBottleFilesId);

    /**
     * 查询液化石油气-气瓶档案列表
     * 
     * @param tLpgGasBottleFiles 液化石油气-气瓶档案
     * @return 液化石油气-气瓶档案集合
     */
    public List<TLpgGasBottleFiles> selectTLpgGasBottleFilesList(TLpgGasBottleFiles tLpgGasBottleFiles);

    /**
     * 导出查询
     * @param tLpgGasBottleFiles t
     * @return r
     */
    public List<TLpgGasBottleFiles> exportTLpgGasBottleFilesList(TLpgGasBottleFiles tLpgGasBottleFiles);

    /**
     * 根据 气瓶条码 集合查询数据
     * @param codeList codelist
     * @return r
     */
    public List<TLpgGasBottleFiles> queryAllByFQRcodeList(@Param("codeList") List<String> codeList);

    /**
     * 根据 气瓶集合 和 企业id 查询数据
     * @param list list
     * @param enterpriseId e
     * @return r
     */
    public List<TLpgGasBottleFiles> queryAllByQrcodeAndEnterpriseList(@Param("list") List<String> list, @Param("enterpriseId") String enterpriseId);

    /**
     * 新增液化石油气-气瓶档案
     * 
     * @param tLpgGasBottleFiles 液化石油气-气瓶档案
     * @return 结果
     */
    public int insertTLpgGasBottleFiles(TLpgGasBottleFiles tLpgGasBottleFiles);

    /**
     * 批量插入
     * @param list list
     * @return r
     */
    public int insertBatch(@Param("list") List<TLpgGasBottleFiles> list);

    /**
     * 批量修改
     * @param list l
     * @return r
     */
    public int updateBatch(@Param("list") List<TLpgGasBottleFiles> list);

    /**
     * 修改液化石油气-气瓶档案
     * 
     * @param tLpgGasBottleFiles 液化石油气-气瓶档案
     * @return 结果
     */
    public int updateTLpgGasBottleFiles(TLpgGasBottleFiles tLpgGasBottleFiles);

    /**
     * 删除液化石油气-气瓶档案
     * 
     * @param fGasBottleFilesId 液化石油气-气瓶档案ID
     * @return 结果
     */
    public int deleteTLpgGasBottleFilesById(Long fGasBottleFilesId);

    /**
     * 批量删除液化石油气-气瓶档案
     * 
     * @param fGasBottleFilesIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTLpgGasBottleFilesByIds(Long[] fGasBottleFilesIds);
}
