package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TInspectReport;

/**
 * 入户安检结果Mapper接口
 * 
 * @author zehong
 * @date 2026-02-02
 */
public interface TInspectReportMapper 
{
    /**
     * 查询入户安检结果
     * 
     * @param reportId 入户安检结果ID
     * @return 入户安检结果
     */
    public TInspectReport selectTInspectReportById(Long reportId);

    /**
     * 查询入户安检结果列表
     * 
     * @param tInspectReport 入户安检结果
     * @return 入户安检结果集合
     */
    public List<TInspectReport> selectTInspectReportList(TInspectReport tInspectReport);

    /**
     * 安检汇总列表
     * @param tInspectReport
     * @return
     */
    public List<TInspectReport> selectTInspectSummaryList(TInspectReport tInspectReport);

    /**
     * 新增入户安检结果
     * 
     * @param tInspectReport 入户安检结果
     * @return 结果
     */
    public int insertTInspectReport(TInspectReport tInspectReport);
    public int inserts(List<TInspectReport> list);

    /**
     * 修改入户安检结果
     * 
     * @param tInspectReport 入户安检结果
     * @return 结果
     */
    public int updateTInspectReport(TInspectReport tInspectReport);

    /**
     * 删除入户安检结果
     * 
     * @param reportId 入户安检结果ID
     * @return 结果
     */
    public int deleteTInspectReportById(Long reportId);

    /**
     * 批量删除入户安检结果
     * 
     * @param reportIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTInspectReportByIds(Long[] reportIds);
}
