package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TInsSpotHazardRef;

/**
 * 监督检查-抽查隐患Mapper接口
 * 
 * @author zehong
 * @date 2024-05-21
 */
public interface TInsSpotHazardRefMapper 
{
    /**
     * 查询监督检查-抽查隐患
     * 
     * @param fInsSpotHazardRefId 监督检查-抽查隐患ID
     * @return 监督检查-抽查隐患
     */
    public TInsSpotHazardRef selectTInsSpotHazardRefById(Long fInsSpotHazardRefId);

    /**
     * 查询监督检查-抽查隐患列表
     * 
     * @param tInsSpotHazardRef 监督检查-抽查隐患
     * @return 监督检查-抽查隐患集合
     */
    public List<TInsSpotHazardRef> selectTInsSpotHazardRefList(TInsSpotHazardRef tInsSpotHazardRef);

    /**
     * 新增监督检查-抽查隐患
     * 
     * @param tInsSpotHazardRef 监督检查-抽查隐患
     * @return 结果
     */
    public int insertTInsSpotHazardRef(TInsSpotHazardRef tInsSpotHazardRef);

    /**
     * 修改监督检查-抽查隐患
     * 
     * @param tInsSpotHazardRef 监督检查-抽查隐患
     * @return 结果
     */
    public int updateTInsSpotHazardRef(TInsSpotHazardRef tInsSpotHazardRef);

    /**
     * 抽查隐患处置
     * @param tInsSpotHazardRef t
     * @return r
     */
    public int disposeOfInsSpotHazardRef(TInsSpotHazardRef tInsSpotHazardRef);

    /**
     * 删除监督检查-抽查隐患
     * 
     * @param fInsSpotHazardRefId 监督检查-抽查隐患ID
     * @return 结果
     */
    public int deleteTInsSpotHazardRefById(Long fInsSpotHazardRefId);

    /**
     * 批量删除监督检查-抽查隐患
     * 
     * @param fInsSpotHazardRefIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTInsSpotHazardRefByIds(Long[] fInsSpotHazardRefIds);

    /**
     * 批量插入
     * @param list 批量数据
     * @return
     */
    int batchInsertTInsSpotHazardRef(List<TInsSpotHazardRef> list);

}
