package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TInsScopeInfor;

/**
 * 监督检查-检查范围Mapper接口
 * 
 * @author zehong
 * @date 2024-05-16
 */
public interface TInsScopeInforMapper 
{
    /**
     * 查询监督检查-检查范围
     * 
     * @param fScopeInforId 监督检查-检查范围ID
     * @return 监督检查-检查范围
     */
    public TInsScopeInfor selectTInsScopeInforById(Long fScopeInforId);

    /**
     * 查询监督检查-检查范围列表
     * 
     * @param tInsScopeInfor 监督检查-检查范围
     * @return 监督检查-检查范围集合
     */
    public List<TInsScopeInfor> selectTInsScopeInforList(TInsScopeInfor tInsScopeInfor);

    /**
     * 新增监督检查-检查范围
     * 
     * @param tInsScopeInfor 监督检查-检查范围
     * @return 结果
     */
    public int insertTInsScopeInfor(TInsScopeInfor tInsScopeInfor);

    /**
     * 修改监督检查-检查范围
     * 
     * @param tInsScopeInfor 监督检查-检查范围
     * @return 结果
     */
    public int updateTInsScopeInfor(TInsScopeInfor tInsScopeInfor);

    /**
     * 删除监督检查-检查范围
     * 
     * @param fScopeInforId 监督检查-检查范围ID
     * @return 结果
     */
    public int deleteTInsScopeInforById(Long fScopeInforId);

    /**
     * 批量删除监督检查-检查范围
     * 
     * @param fScopeInforIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTInsScopeInforByIds(Long[] fScopeInforIds);

    /**
     * 批量插入
     * @param list 批量数据
     * @return
     */
    int batchInsertTInsScopeInfor(List<TInsScopeInfor> list);
}
