package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TEventReceive;

/**
 * 事件接报Mapper接口
 * 
 * @author zehong
 * @date 2022-03-18
 */
public interface TEventReceiveMapper 
{
    /**
     * 查询事件接报
     * 
     * @param id 事件接报ID
     * @return 事件接报
     */
    public TEventReceive selectTEventReceiveById(String id);

    /**
     * 查询事件接报列表
     * 
     * @param tEventReceive 事件接报
     * @return 事件接报集合
     */
    public List<TEventReceive> selectTEventReceiveList(TEventReceive tEventReceive);

    /**
     * 新增事件接报
     * 
     * @param tEventReceive 事件接报
     * @return 结果
     */
    public int insertTEventReceive(TEventReceive tEventReceive);

    /**
     * 修改事件接报
     * 
     * @param tEventReceive 事件接报
     * @return 结果
     */
    public int updateTEventReceive(TEventReceive tEventReceive);

    /**
     * 删除事件接报
     * 
     * @param id 事件接报ID
     * @return 结果
     */
    public int deleteTEventReceiveById(String id);

    /**
     * 批量删除事件接报
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    public int deleteTEventReceiveByIds(String[] ids);

    public List<TEventReceive> getReadReceiveList(Integer enterpriseId);
}
