package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TEnterpriseInfo;
import org.apache.ibatis.annotations.Param;
import org.springframework.web.bind.annotation.PathVariable;

/**
 * 企业信息Mapper接口
 * 
 * @author zehong
 * @date 2022-01-24
 */
public interface TEnterpriseInfoMapper 
{
    /**
     * 查询企业信息
     * 
     * @param enterpriseId 企业信息ID
     * @return 企业信息
     */
    public TEnterpriseInfo selectTEnterpriseInfoById(String enterpriseId);

    /**
     * 查询企业信息
     *
     * @param enterpriseName 企业信息名称
     * @return 企业信息
     */
    public List<TEnterpriseInfo> selectTEnterpriseInfoByName(String enterpriseName);

    /**
     * 根据企业名称集合 查询 企业集合数据
     * @param list list
     * @return r
     */
    public List<TEnterpriseInfo> queryAllByEnterpriseNameList(@Param("list") List<String> list);

    /**
     * 查询企业信息列表
     * 
     * @param tEnterpriseInfo 企业信息
     * @return 企业信息集合
     */
    public List<TEnterpriseInfo> selectTEnterpriseInfoList(TEnterpriseInfo tEnterpriseInfo);

    /**
     * 无条件查询所有企业
     * @return r
     */
    public List<TEnterpriseInfo> queryAllEnterprise();

    /**
     * 新增企业信息
     * 
     * @param tEnterpriseInfo 企业信息
     * @return 结果
     */
    public int insertTEnterpriseInfo(TEnterpriseInfo tEnterpriseInfo);

    /**
     * 修改企业信息
     * 
     * @param tEnterpriseInfo 企业信息
     * @return 结果
     */
    public int updateTEnterpriseInfo(TEnterpriseInfo tEnterpriseInfo);

    /**
     * 删除企业信息
     * 
     * @param enterpriseId 企业信息ID
     * @return 结果
     */
    public int deleteTEnterpriseInfoById(String enterpriseId);

    /**
     * 批量删除企业信息
     * 
     * @param enterpriseIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTEnterpriseInfoByIds(String[] enterpriseIds);
}
