package com.zehong.system.mapper;

import com.zehong.system.domain.TDetectorInfo;
import com.zehong.system.domain.TDetectorReportData;
import com.zehong.system.domain.form.TDetectorReportDataQueryForm;
import com.zehong.system.domain.vo.TDetectorAlarmInfoVO;

import java.util.List;

/**
 * 设备上报的数据Mapper接口
 * 
 * @author zehong
 * @date 2021-11-08
 */
public interface TDetectorReportDataMapper 
{
    /**
     * 查询设备上报的数据
     * 
     * @param id 设备上报的数据ID
     * @return 设备上报的数据
     */
    public TDetectorReportData selectTDetectorReportDataById(Long id);


    public List<TDetectorReportData> selectTDetectorReportDataByCode(String detectorCode);

    public List<TDetectorReportData> countDetectorByUserId(TDetectorInfo tDetectorInfo);

    public List<TDetectorAlarmInfoVO> selectTDetectorAlarm();

    public List<TDetectorReportData> selectRealtimeDataList();

    /**
     * 查询设备上报的数据列表
     * 
     * @param tDetectorReportDataQueryForm 设备上报的数据
     * @return 设备上报的数据集合
     */
    public List<TDetectorReportData> selectTDetectorReportDataList(TDetectorReportDataQueryForm tDetectorReportDataQueryForm);

    /**
     * 新增设备上报的数据
     * 
     * @param tDetectorReportData 设备上报的数据
     * @return 结果
     */
    public int insertTDetectorReportData(TDetectorReportData tDetectorReportData);

    /**
     * 修改设备上报的数据
     * 
     * @param tDetectorReportData 设备上报的数据
     * @return 结果
     */
    public int updateTDetectorReportData(TDetectorReportData tDetectorReportData);

    /**
     * 删除设备上报的数据
     * 
     * @param id 设备上报的数据ID
     * @return 结果
     */
    public int deleteTDetectorReportDataById(Long id);

    /**
     * 批量删除设备上报的数据
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    public int deleteTDetectorReportDataByIds(Long[] ids);

    public TDetectorAlarmInfoVO  selectAlarm(Integer id);
}
