package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TCountyLevelRegion;
import org.apache.ibatis.annotations.Param;

/**
 * 县级行政区Mapper接口
 * 
 * @author zehong
 * @date 2024-06-06
 */
public interface TCountyLevelRegionMapper 
{
    /**
     * 查询县级行政区
     * 
     * @param fId 县级行政区ID
     * @return 县级行政区
     */
    public TCountyLevelRegion selectTCountyLevelRegionById(Long fId);

    /**
     * 查询县级行政区列表
     * 
     * @param tCountyLevelRegion 县级行政区
     * @return 县级行政区集合
     */
    public List<TCountyLevelRegion> selectTCountyLevelRegionList(TCountyLevelRegion tCountyLevelRegion);

    /**
     * 根据 countyCodes 集合查询数据
     * @param list c
     * @return r
     */
    public List<TCountyLevelRegion> queryByCountyCodes(@Param("list") List<String> list);
    /**
     * 根据city_code 查询
     * @param fCityId c
     * @return r
     */
    public List<TCountyLevelRegion> queryByCityId(String fCityId);

    /**
     * 新增县级行政区
     * 
     * @param tCountyLevelRegion 县级行政区
     * @return 结果
     */
    public int insertTCountyLevelRegion(TCountyLevelRegion tCountyLevelRegion);

    /**
     * 修改县级行政区
     * 
     * @param tCountyLevelRegion 县级行政区
     * @return 结果
     */
    public int updateTCountyLevelRegion(TCountyLevelRegion tCountyLevelRegion);

    /**
     * 删除县级行政区
     * 
     * @param fId 县级行政区ID
     * @return 结果
     */
    public int deleteTCountyLevelRegionById(Long fId);

    /**
     * 批量删除县级行政区
     * 
     * @param fIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTCountyLevelRegionByIds(Long[] fIds);

    /**
     * 批量添加
     * @param list 批量数据
     * @return
     */
    int batchInsertTCountyLevelRegion(List<TCountyLevelRegion> list);
}
